(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9077,        296]
NotebookOptionsPosition[      7068,        237]
NotebookOutlinePosition[      8388,        270]
CellTagsIndexPosition[      8345,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddEdge" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddEdge"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"AddEdge\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddEdges", "ObjectName",
 CellID->32113],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddEdges", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["edgeList", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the new edges in ",
     Cell[BoxData[
      StyleBox["edgeList", "TI"]], "InlineFormula"],
     " added. ",
     Cell[BoxData[
      StyleBox["edgeList", "TI"]], "InlineFormula"],
     " can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
     " to add a single edge ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", to add edges ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}], ",", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}], ",", "y"}], "}"}], ",", 
         "\[Ellipsis]"}], "}"}], TraditionalForm]]],
     ", where ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " can specify graphics information associated with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}], TraditionalForm]], "InlineMath"],
     ", respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27422]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17519],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AddEdge",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/AddEdge"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24083]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->242466254],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->175504682]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->170363058],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->40327610]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 47, 56.7556976}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AddEdges[g, edgeList] gives graph g with the new edges in edgeList \
added. edgeList can have the form {a, b} to add a single edge {a, b} or the \
form {{a, b}, {c, d}, ...}, to add edges {a, b}, {c, d}, ... or the form \
{{{a, b}, x}, {{c, d}, y}, ...}, where x and y can specify graphics \
information associated with {a, b} and {c, d}, respectively.", 
    "synonyms" -> {}, "title" -> "AddEdges", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/AddEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1994, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2617, 79, 46, 1, 70, "ObjectName",
 CellID->32113],
Cell[2666, 82, 2528, 82, 70, "Usage",
 CellID->27422]
}, Open  ]],
Cell[CellGroupData[{
Cell[5231, 169, 311, 9, 70, "SeeAlsoSection",
 CellID->17519],
Cell[5545, 180, 208, 6, 70, "SeeAlso",
 CellID->24083]
}, Open  ]],
Cell[CellGroupData[{
Cell[5790, 191, 318, 9, 70, "TutorialsSection",
 CellID->242466254],
Cell[6111, 202, 187, 4, 70, "Tutorials",
 CellID->175504682]
}, Open  ]],
Cell[CellGroupData[{
Cell[6335, 211, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6657, 222, 163, 3, 70, "MoreAbout",
 CellID->170363058],
Cell[6823, 227, 203, 5, 70, "MoreAbout",
 CellID->40327610]
}, Open  ]],
Cell[7041, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

