(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9347,        306]
NotebookOptionsPosition[      7328,        248]
NotebookOutlinePosition[      8721,        282]
CellTagsIndexPosition[      8678,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddVertex" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddVertex"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"AddVertex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddVertices", "ObjectName",
 CellID->13675],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " disconnected vertices to graph ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["vList", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]adds vertices in ",
     Cell[BoxData[
      StyleBox["vList", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". ",
     Cell[BoxData[
      StyleBox["vList", "TI"]], "InlineFormula"],
     " contains embedding and graphics information and can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     " or ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["y", "1"]}], "}"}], ",", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox["x", "2"], ",", 
            SubscriptBox["y", "2"]}], "}"}], " ", "\[Ellipsis]"}]}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", "1"], ",", 
             SubscriptBox["y", "1"]}], "}"}], ",", 
           SubscriptBox["g", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", "2"], ",", 
             SubscriptBox["y", "2"]}], "}"}], ",", 
           SubscriptBox["g", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["y", "1"]}], "}"}], TraditionalForm]], "InlineMath"],
     ", and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["y", "2"]}], "}"}], TraditionalForm]], "InlineMath"],
     " are point coordinates and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "2"], TraditionalForm]], "InlineMath"],
     " are graphics information associated with vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32297],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["AddVertex",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/AddVertex"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->26009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->421274444],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->25352649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->239514569]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 2.6620988}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AddVertices[g, n] adds n disconnected vertices to graph g. \
AddVertices[g, vList] adds vertices in vList to g. vList contains embedding \
and graphics information and can have the form {x, y} or {{x_1, y_1}, {x_2, \
y_2} ...} or the form {{{x_1, y_1}, g_1}, {{x_2, y_2}, g_2}, ...}, where {x, \
y}, {x_1, y_1}, and {x_2, y_2} are point coordinates and g_1 and g_2 are \
graphics information associated with vertices.", "synonyms" -> {}, "title" -> 
    "AddVertices", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/AddVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1782, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2405, 75, 49, 1, 70, "ObjectName",
 CellID->13675],
Cell[2457, 78, 3200, 104, 70, "Usage",
 CellID->245]
}, Open  ]],
Cell[CellGroupData[{
Cell[5694, 187, 311, 9, 70, "SeeAlsoSection",
 CellID->32297],
Cell[6008, 198, 212, 6, 70, "SeeAlso",
 CellID->26009]
}, Open  ]],
Cell[CellGroupData[{
Cell[6257, 209, 318, 9, 70, "TutorialsSection",
 CellID->421274444],
Cell[6578, 220, 186, 4, 70, "Tutorials",
 CellID->25352649]
}, Open  ]],
Cell[CellGroupData[{
Cell[6801, 229, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7123, 240, 163, 3, 70, "MoreAbout",
 CellID->239514569]
}, Open  ]],
Cell[7301, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

