(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9122,        292]
NotebookOptionsPosition[      7073,        234]
NotebookOutlinePosition[      8495,        268]
CellTagsIndexPosition[      8452,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShortestPath" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShortestPath"], 
          "ShortestPathSpanningTree" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPathSpanningTree"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ShortestPath\"\>", 
       2->"\<\"ShortestPathSpanningTree\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AllPairsShortestPath", "ObjectName",
 CellID->5635],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AllPairsShortestPath", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a matrix, where the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", ",", "j"}], ")"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is the length of a shortest path in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " between vertices ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AllPairsShortestPath", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", "Parent"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a three-dimensional matrix with dimensions ",
     Cell[BoxData[
      RowBox[{
       StyleBox["2", "TR"], "*", 
       RowBox[{"V", "[", 
        StyleBox["g", "TI"], "]"}], "*", 
       RowBox[{"V", "[", 
        StyleBox["g", "TI"], "]"}]}]], "InlineFormula"],
     ", in which the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "i", ",", "j"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is the length of a shortest path from ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " and the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "i", ",", "j"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " entry is the predecessor of ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " in a shortest path from ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22229],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPathSpanningTree",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPathSpanningTree"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->542048315],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->564352435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->456089419]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AllPairsShortestPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 3.3496164}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AllPairsShortestPath[g] gives a matrix, where the (i, j)\\[Null]^th \
entry is the length of a shortest path in g between vertices i and j. \
AllPairsShortestPath[g, Parent] returns a three-dimensional matrix with \
dimensions 2*V[g]*V[g], in which the (1, i, j)\\[Null]^th entry is the length \
of a shortest path from i to j and the (2, i, j)\\[Null]^th entry is the \
predecessor of j in a shortest path from i to j.", "synonyms" -> {}, "title" -> 
    "AllPairsShortestPath", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/AllPairsShortestPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1955, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2578, 77, 57, 1, 70, "ObjectName",
 CellID->5635],
Cell[2638, 80, 2463, 77, 70, "Usage",
 CellID->28621]
}, Open  ]],
Cell[CellGroupData[{
Cell[5138, 162, 311, 9, 70, "SeeAlsoSection",
 CellID->22229],
Cell[5452, 173, 518, 17, 70, "SeeAlso",
 CellID->8853]
}, Open  ]],
Cell[CellGroupData[{
Cell[6007, 195, 318, 9, 70, "TutorialsSection",
 CellID->542048315],
Cell[6328, 206, 187, 4, 70, "Tutorials",
 CellID->564352435]
}, Open  ]],
Cell[CellGroupData[{
Cell[6552, 215, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6874, 226, 157, 3, 70, "MoreAbout",
 CellID->456089419]
}, Open  ]],
Cell[7046, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

