(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8597,        271]
NotebookOptionsPosition[      6484,        212]
NotebookOutlinePosition[      7972,        247]
CellTagsIndexPosition[      7929,        244]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Highlight" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Highlight"], 
          "ShowGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShowGraph"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Highlight\"\>", 
       2->"\<\"ShowGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AnimateGraph", "ObjectName",
 CellID->7901],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AnimateGraph", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with each element in the list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " successively highlighted. Here ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " is a list containing vertices and edges of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". An optional flag, which takes on the values ",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["One",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/One"]], "InlineFormula"],
     ", can be used to inform the function about whether objects highlighted \
earlier will continue to be highlighted or not. The default value of flag is \
",
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     ". All the options allowed by the function ",
     Cell[BoxData[
      ButtonBox["Highlight",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Highlight"]], "InlineFormula"],
     " are permitted by ",
     Cell[BoxData["AnimateGraph"], "InlineFormula"],
     ", as well. See the usage message of ",
     Cell[BoxData[
      ButtonBox["Highlight",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Highlight"]], "InlineFormula"],
     " for more details."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14780],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Highlight",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Highlight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShowGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31681952],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->24261047]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->879813349]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AnimateGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 4.7246516}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "AnimateGraph[g, l] displays graph g with each element in the list l \
successively highlighted. Here l is a list containing vertices and edges of \
g. An optional flag, which takes on the values All and One, can be used to \
inform the function about whether objects highlighted earlier will continue \
to be highlighted or not. The default value of flag is All. All the options \
allowed by the function Highlight are permitted by AnimateGraph, as well. See \
the usage message of Highlight for more details.", "synonyms" -> {}, "title" -> 
    "AnimateGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/AnimateGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1901, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2524, 77, 49, 1, 70, "ObjectName",
 CellID->7901],
Cell[2576, 80, 1971, 55, 70, "Usage",
 CellID->8361]
}, Open  ]],
Cell[CellGroupData[{
Cell[4584, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->14780],
Cell[4898, 151, 483, 17, 70, "SeeAlso",
 CellID->28818]
}, Open  ]],
Cell[CellGroupData[{
Cell[5418, 173, 317, 9, 70, "TutorialsSection",
 CellID->31681952],
Cell[5738, 184, 186, 4, 70, "Tutorials",
 CellID->24261047]
}, Open  ]],
Cell[CellGroupData[{
Cell[5961, 193, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6283, 204, 159, 3, 70, "MoreAbout",
 CellID->879813349]
}, Open  ]],
Cell[6457, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

