(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6930,        227]
NotebookOptionsPosition[      5161,        173]
NotebookOutlinePosition[      6304,        203]
CellTagsIndexPosition[      6261,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BiconnectedComponents" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BiconnectedComponents"], "Bridges" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Bridges"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BiconnectedComponents\"\>", 
       2->"\<\"Bridges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Cycles and Connectivity\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ArticulationVertices", "ObjectName",
 CellID->12012],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ArticulationVertices", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all articulation vertices in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". These are vertices whose removal will disconnect the graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23718],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BiconnectedComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BiconnectedComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bridges",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Bridges"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1851]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->110381348],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->154458800]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->214299219]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ArticulationVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 10.9123100}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ArticulationVertices[g] gives a list of all articulation vertices in \
graph g. These are vertices whose removal will disconnect the graph.", 
    "synonyms" -> {}, "title" -> "ArticulationVertices", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/ArticulationVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1949, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2572, 77, 58, 1, 70, "ObjectName",
 CellID->12012],
Cell[2633, 80, 557, 15, 70, "Usage",
 CellID->3912]
}, Open  ]],
Cell[CellGroupData[{
Cell[3227, 100, 311, 9, 70, "SeeAlsoSection",
 CellID->23718],
Cell[3541, 111, 502, 17, 70, "SeeAlso",
 CellID->1851]
}, Open  ]],
Cell[CellGroupData[{
Cell[4080, 133, 318, 9, 70, "TutorialsSection",
 CellID->110381348],
Cell[4401, 144, 187, 4, 70, "Tutorials",
 CellID->154458800]
}, Open  ]],
Cell[CellGroupData[{
Cell[4625, 153, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4947, 164, 172, 4, 70, "MoreAbout",
 CellID->214299219]
}, Open  ]],
Cell[5134, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

