(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7666,        245]
NotebookOptionsPosition[      5704,        188]
NotebookOutlinePosition[      7038,        221]
CellTagsIndexPosition[      6995,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AllPairsShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/AllPairsShortestPath"], "ShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AllPairsShortestPath\"\>", 
       2->"\<\"ShortestPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BellmanFord", "ObjectName",
 CellID->26979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BellmanFord", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a shortest-path spanning tree and associated \
distances from vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". The shortest-path spanning tree is given by a list in which element ",
     
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " is the predecessor of vertex ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " in the shortest-path spanning tree. ",
     Cell[BoxData["BellmanFord"], "InlineFormula"],
     " works correctly even when the edge weights are negative, provided \
there are no negative cycles."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19046]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15221],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AllPairsShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AllPairsShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18697]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->59786226],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->865058068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->194701644]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BellmanFord - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 11.5529514}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "BellmanFord[g, v] gives a shortest-path spanning tree and associated \
distances from vertex v of graph g. The shortest-path spanning tree is given \
by a list in which element i is the predecessor of vertex i in the \
shortest-path spanning tree. BellmanFord works correctly even when the edge \
weights are negative, provided there are no negative cycles.", 
    "synonyms" -> {}, "title" -> "BellmanFord", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/BellmanFord"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1944, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2567, 77, 49, 1, 70, "ObjectName",
 CellID->26979],
Cell[2619, 80, 1121, 31, 70, "Usage",
 CellID->19046]
}, Open  ]],
Cell[CellGroupData[{
Cell[3777, 116, 311, 9, 70, "SeeAlsoSection",
 CellID->15221],
Cell[4091, 127, 511, 17, 70, "SeeAlso",
 CellID->18697]
}, Open  ]],
Cell[CellGroupData[{
Cell[4639, 149, 317, 9, 70, "TutorialsSection",
 CellID->59786226],
Cell[4959, 160, 187, 4, 70, "Tutorials",
 CellID->865058068]
}, Open  ]],
Cell[CellGroupData[{
Cell[5183, 169, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5505, 180, 157, 3, 70, "MoreAbout",
 CellID->194701644]
}, Open  ]],
Cell[5677, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

