(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8139,        261]
NotebookOptionsPosition[      6171,        204]
NotebookOutlinePosition[      7515,        237]
CellTagsIndexPosition[      7472,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HasseDiagram" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/HasseDiagram"], 
          "Hypercube" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Hypercube"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"HasseDiagram\"\>", 
       2->"\<\"Hypercube\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BooleanAlgebra", "ObjectName",
 CellID->16764],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BooleanAlgebra", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a Hasse diagram for the Boolean algebra on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " elements. The function takes two options: ",
     Cell[BoxData["Type"], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     ", with default values ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", respectively. When ",
     Cell[BoxData["Type"], "InlineFormula"],
     " is set to ",
     Cell[BoxData["Directed"], "InlineFormula"],
     ", the function produces the underlying directed acyclic graph. When ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     " is set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", labels are produced for the vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5047],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HasseDiagram",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HasseDiagram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypercube",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Hypercube"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->541565491],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->354964526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->38365805]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BooleanAlgebra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 21.5219566}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "BooleanAlgebra[n] gives a Hasse diagram for the Boolean algebra on n \
elements. The function takes two options: Type and VertexLabel, with default \
values Undirected and False, respectively. When Type is set to Directed, the \
function produces the underlying directed acyclic graph. When VertexLabel is \
set to True, labels are produced for the vertices.", "synonyms" -> {}, 
    "title" -> "BooleanAlgebra", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/BooleanAlgebra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1899, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2522, 76, 52, 1, 70, "ObjectName",
 CellID->16764],
Cell[2577, 79, 1655, 48, 70, "Usage",
 CellID->9948]
}, Open  ]],
Cell[CellGroupData[{
Cell[4269, 132, 310, 9, 70, "SeeAlsoSection",
 CellID->5047],
Cell[4582, 143, 487, 17, 70, "SeeAlso",
 CellID->831]
}, Open  ]],
Cell[CellGroupData[{
Cell[5106, 165, 318, 9, 70, "TutorialsSection",
 CellID->541565491],
Cell[5427, 176, 187, 4, 70, "Tutorials",
 CellID->354964526]
}, Open  ]],
Cell[CellGroupData[{
Cell[5651, 185, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5973, 196, 156, 3, 70, "MoreAbout",
 CellID->38365805]
}, Open  ]],
Cell[6144, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

