(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8012,        254]
NotebookOptionsPosition[      5952,        196]
NotebookOutlinePosition[      7384,        230]
CellTagsIndexPosition[      7341,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DepthFirstTraversal" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DepthFirstTraversal"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DepthFirstTraversal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BreadthFirstTraversal", "ObjectName",
 CellID->27430],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BreadthFirstTraversal", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a breadth-first traversal of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " starting from vertex ",
     Cell[BoxData[
      FormBox[
       StyleBox["v", "TI"], TraditionalForm]], "InlineFormula"],
     ", and gives the breadth-first numbers of the vertices. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"BreadthFirstTraversal", "["}], 
       StyleBox["g", "TI"], ",", 
       StyleBox["v", "TI"], ",", 
       RowBox[{"Edge", "]"}]}]], "InlineFormula"],
     "\[LineSeparator]returns the edges of the graph that are traversed by \
breadth-first traversal. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"BreadthFirstTraversal", "["}], 
       StyleBox["g", "TI"], ",", 
       StyleBox["v", "TI"], ",", 
       RowBox[{"Tree", "]"}]}]], "InlineFormula"],
     "\[LineSeparator]returns the breadth-first search tree. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"BreadthFirstTraversal", "["}], 
       StyleBox["g", "TI"], ",", 
       StyleBox["v", "TI"], ",", 
       RowBox[{
        ButtonBox["Level",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Level"], "]"}]}]], "InlineFormula"],
     "\[LineSeparator]returns the level number of the vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17290],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DepthFirstTraversal",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/DepthFirstTraversal"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->208010536],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->354964526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->107346691]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BreadthFirstTraversal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 22.1469726}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "BreadthFirstTraversal[g, v] performs a breadth-first traversal of graph \
g starting from vertex v, and gives the breadth-first numbers of the \
vertices. BreadthFirstTraversal[ g, v, Edge] returns the edges of the graph \
that are traversed by breadth-first traversal. BreadthFirstTraversal[ g, v, \
Tree] returns the breadth-first search tree. BreadthFirstTraversal[ g, v, \
Level] returns the level number of the vertices.", "synonyms" -> {}, "title" -> 
    "BreadthFirstTraversal", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/BreadthFirstTraversal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1806, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2429, 75, 59, 1, 70, "ObjectName",
 CellID->27430],
Cell[2491, 78, 1775, 52, 70, "Usage",
 CellID->11351]
}, Open  ]],
Cell[CellGroupData[{
Cell[4303, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->17290],
Cell[4617, 146, 232, 6, 70, "SeeAlso",
 CellID->31219]
}, Open  ]],
Cell[CellGroupData[{
Cell[4886, 157, 318, 9, 70, "TutorialsSection",
 CellID->208010536],
Cell[5207, 168, 187, 4, 70, "Tutorials",
 CellID->354964526]
}, Open  ]],
Cell[CellGroupData[{
Cell[5431, 177, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5753, 188, 157, 3, 70, "MoreAbout",
 CellID->107346691]
}, Open  ]],
Cell[5925, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

