(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9438,        298]
NotebookOptionsPosition[      7226,        238]
NotebookOutlinePosition[      8812,        274]
CellTagsIndexPosition[      8769,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeBruijnGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/DeBruijnGraph"], 
          "Hypercube" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Hypercube"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DeBruijnGraph\"\>", 
       2->"\<\"Hypercube\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButterflyGraph", "ObjectName",
 CellID->30316],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButterflyGraph", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-dimensional butterfly graph, a directed graph whose vertices are pairs \
",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"w", ",", "i"}], ")"}], TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " is a binary string of length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " is an integer in the range 0 through ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and whose edges go from vertex ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"w", ",", "i"}], ")"}], TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["w", "\[Prime]"], ",", 
         RowBox[{"i", "+", "1"}]}], ")"}], TraditionalForm]], "InlineMath"],
     ", if ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], TraditionalForm]], "InlineMath"],
     " is identical to ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " in all bits with the possible exception of the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", "+", "1"}], ")"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " bit. Here bits are counted left to right. An option ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     ", with default setting ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", is allowed. When this option is set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", vertices are labeled with strings ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"w", ",", "i"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17723],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeBruijnGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeBruijnGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypercube",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Hypercube"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->46879140],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->36712713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->287452859]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButterflyGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 26.3814560}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ButterflyGraph[n] returns the n-dimensional butterfly graph, a directed \
graph whose vertices are pairs (w, i), where w is a binary string of length n \
and i is an integer in the range 0 through n and whose edges go from vertex \
(w, i) to (w^\\[Prime], i + 1), if SuperscriptBox[\"w\", \"\\[Prime]\", \
MultilineFunction->None] is identical to w in all bits with the possible \
exception of the (i + 1)\\[Null]^th bit. Here bits are counted left to right. \
An option VertexLabel, with default setting False, is allowed. When this \
option is set to True, vertices are labeled with strings (w, i).", 
    "synonyms" -> {}, "title" -> "ButterflyGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ButterflyGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1898, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2521, 76, 52, 1, 70, "ObjectName",
 CellID->30316],
Cell[2576, 79, 2711, 82, 70, "Usage",
 CellID->18403]
}, Open  ]],
Cell[CellGroupData[{
Cell[5324, 166, 311, 9, 70, "SeeAlsoSection",
 CellID->17723],
Cell[5638, 177, 490, 17, 70, "SeeAlso",
 CellID->7189]
}, Open  ]],
Cell[CellGroupData[{
Cell[6165, 199, 317, 9, 70, "TutorialsSection",
 CellID->46879140],
Cell[6485, 210, 186, 4, 70, "Tutorials",
 CellID->36712713]
}, Open  ]],
Cell[CellGroupData[{
Cell[6708, 219, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7030, 230, 154, 3, 70, "MoreAbout",
 CellID->287452859]
}, Open  ]],
Cell[7199, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

