(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8926,        288]
NotebookOptionsPosition[      6911,        229]
NotebookOutlinePosition[      8237,        262]
CellTagsIndexPosition[      8194,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChangeEdges" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChangeEdges"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChangeEdges\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChangeVertices", "ObjectName",
 CellID->24171],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ChangeVertices", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the vertices of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with the vertices in the given list ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     ". ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "1"], ",", 
           SubscriptBox["y", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["x", "2"], ",", 
           SubscriptBox["y", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     " or the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", "1"], ",", 
             SubscriptBox["y", "1"]}], "}"}], ",", 
           SubscriptBox["gr", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox["x", "2"], ",", 
             SubscriptBox["y", "2"]}], "}"}], ",", 
           SubscriptBox["gr", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "1"], ",", 
          SubscriptBox["y", "1"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["x", "2"], ",", 
          SubscriptBox["y", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     " are coordinates of points and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["gr", "1"], ",", 
        SubscriptBox["gr", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " are graphics information associated with vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6438]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30386],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ChangeEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/ChangeEdges"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18972]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->164830196],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->520344110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->470417856],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->241716692]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChangeVertices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 27.0533482}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ChangeVertices[g, v] replaces the vertices of graph g with the vertices \
in the given list v. v can have the form {{x_1, y_1}, {x_2, y_2}, ...} or the \
form {{{x_1, y_1}, gr_1}, {{x_2, y_2}, gr_2}, ...}, where {x_1, y_1}, {x_2, \
y_2}, ... are coordinates of points and gr_1, gr_2, ... are graphics \
information associated with vertices.", "synonyms" -> {}, "title" -> 
    "ChangeVertices", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ChangeVertices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1953, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2576, 78, 52, 1, 70, "ObjectName",
 CellID->24171],
Cell[2631, 81, 2442, 77, 70, "Usage",
 CellID->6438]
}, Open  ]],
Cell[CellGroupData[{
Cell[5110, 163, 311, 9, 70, "SeeAlsoSection",
 CellID->30386],
Cell[5424, 174, 216, 6, 70, "SeeAlso",
 CellID->18972]
}, Open  ]],
Cell[CellGroupData[{
Cell[5677, 185, 318, 9, 70, "TutorialsSection",
 CellID->164830196],
Cell[5998, 196, 187, 4, 70, "Tutorials",
 CellID->520344110]
}, Open  ]],
Cell[CellGroupData[{
Cell[6222, 205, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6544, 216, 163, 3, 70, "MoreAbout",
 CellID->470417856],
Cell[6710, 221, 159, 3, 70, "MoreAbout",
 CellID->241716692]
}, Open  ]],
Cell[6884, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

