(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6848,        225]
NotebookOptionsPosition[      5106,        171]
NotebookOutlinePosition[      6223,        201]
CellTagsIndexPosition[      6180,        198]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChromaticPolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ChromaticPolynomial"], 
          "MinimumVertexColoring" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MinimumVertexColoring"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ChromaticPolynomial\"\>", 
       2->"\<\"MinimumVertexColoring\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ChromaticNumber", "ObjectName",
 CellID->14368],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ChromaticNumber", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the chromatic number of the graph, which is the \
fewest number of colors necessary to color the graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23646],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChromaticPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ChromaticPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimumVertexColoring",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MinimumVertexColoring"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28357770],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->610254068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->76869989]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ChromaticNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 27.2252276}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ChromaticNumber[g] gives the chromatic number of the graph, which is the \
fewest number of colors necessary to color the graph.", "synonyms" -> {}, 
    "title" -> "ChromaticNumber", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ChromaticNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1979, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2602, 78, 53, 1, 70, "ObjectName",
 CellID->14368],
Cell[2658, 81, 469, 13, 70, "Usage",
 CellID->26396]
}, Open  ]],
Cell[CellGroupData[{
Cell[3164, 99, 311, 9, 70, "SeeAlsoSection",
 CellID->23646],
Cell[3478, 110, 527, 17, 70, "SeeAlso",
 CellID->20333]
}, Open  ]],
Cell[CellGroupData[{
Cell[4042, 132, 317, 9, 70, "TutorialsSection",
 CellID->28357770],
Cell[4362, 143, 187, 4, 70, "Tutorials",
 CellID->610254068]
}, Open  ]],
Cell[CellGroupData[{
Cell[4586, 152, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4908, 163, 156, 3, 70, "MoreAbout",
 CellID->76869989]
}, Open  ]],
Cell[5079, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

