(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8689,        284]
NotebookOptionsPosition[      6751,        228]
NotebookOutlinePosition[      8064,        260]
CellTagsIndexPosition[      8021,        257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CompleteGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/CompleteGraph"], 
          "Cycle" :> Documentation`HelpLookup[
           "paclet:Combinatorica/ref/Cycle"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CompleteGraph\"\>", 
       2->"\<\"Cycle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CirculantGraph", "ObjectName",
 CellID->21501],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CirculantGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a circulant graph on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices, meaning the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " vertex is adjacent to the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", "+", "j"}], ")"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", "-", "j"}], ")"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " vertices, for each ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " in list ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CirculantGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["l", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the graph with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices in which each ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " is adjacent to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", "+", "l"}], ")"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"i", "-", "l"}], ")"}], TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " must be an integer."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15380]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28227],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompleteGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/CompleteGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Cycle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->388]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2904777],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->636577354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->213618788]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CirculantGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 27.8658690}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CirculantGraph[n, l] constructs a circulant graph on n vertices, meaning \
the i\\[Null]^th vertex is adjacent to the (i + j)\\[Null]^th and (i - \
j)\\[Null]^th vertices, for each j in list l. CirculantGraph[n, l] returns \
the graph with n vertices in which each i is adjacent to (i + l) and (i - l), \
where l must be an integer.", "synonyms" -> {}, "title" -> "CirculantGraph", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/CirculantGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1886, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2509, 76, 52, 1, 70, "ObjectName",
 CellID->21501],
Cell[2564, 79, 2257, 72, 70, "Usage",
 CellID->15380]
}, Open  ]],
Cell[CellGroupData[{
Cell[4858, 156, 311, 9, 70, "SeeAlsoSection",
 CellID->28227],
Cell[5172, 167, 481, 17, 70, "SeeAlso",
 CellID->388]
}, Open  ]],
Cell[CellGroupData[{
Cell[5690, 189, 316, 9, 70, "TutorialsSection",
 CellID->2904777],
Cell[6009, 200, 187, 4, 70, "Tutorials",
 CellID->636577354]
}, Open  ]],
Cell[CellGroupData[{
Cell[6233, 209, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6555, 220, 154, 3, 70, "MoreAbout",
 CellID->213618788]
}, Open  ]],
Cell[6724, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

