(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8973,        287]
NotebookOptionsPosition[      7057,        231]
NotebookOutlinePosition[      8346,        263]
CellTagsIndexPosition[      8303,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConnectedComponents" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ConnectedComponents"], 
          "StronglyConnectedComponents" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/StronglyConnectedComponents"], 
          "WeaklyConnectedComponents" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/WeaklyConnectedComponents"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ConnectedComponents\"\>", 
       2->"\<\"StronglyConnectedComponents\"\>", 
       3->"\<\"WeaklyConnectedComponents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Cycles and Connectivity\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConnectedQ", "ObjectName",
 CellID->20037],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConnectedQ", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if undirected graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is connected. If ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is directed, the function returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the underlying undirected graph is connected. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConnectedQ", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", "Strong"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the directed graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is strongly connected."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConnectedQ", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", "Weak"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the directed graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is weakly connected."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18569]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24049],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConnectedComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ConnectedComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StronglyConnectedComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/StronglyConnectedComponents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeaklyConnectedComponents",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/WeaklyConnectedComponents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->580142015],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->12652580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->190493041]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConnectedQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 43.1162594}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ConnectedQ[g] yields True if undirected graph g is connected. If g is \
directed, the function returns True if the underlying undirected graph is \
connected. ConnectedQ[g, Strong] yields True if the directed graph g is \
strongly connected. ConnectedQ[g, Weak] yields True if the directed graph g \
is weakly connected.", "synonyms" -> {}, "title" -> "ConnectedQ", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/ConnectedQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2218, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2841, 83, 48, 1, 70, "ObjectName",
 CellID->20037],
Cell[2892, 86, 1866, 58, 70, "Usage",
 CellID->18569]
}, Open  ]],
Cell[CellGroupData[{
Cell[4795, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->24049],
Cell[5109, 160, 831, 26, 70, "SeeAlso",
 CellID->3106]
}, Open  ]],
Cell[CellGroupData[{
Cell[5977, 191, 318, 9, 70, "TutorialsSection",
 CellID->580142015],
Cell[6298, 202, 186, 4, 70, "Tutorials",
 CellID->12652580]
}, Open  ]],
Cell[CellGroupData[{
Cell[6521, 211, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6843, 222, 172, 4, 70, "MoreAbout",
 CellID->190493041]
}, Open  ]],
Cell[7030, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

