(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7380,        239]
NotebookOptionsPosition[      5482,        183]
NotebookOutlinePosition[      6757,        215]
CellTagsIndexPosition[      6714,        212]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButterflyGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ButterflyGraph"],
           "Hypercube" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Hypercube"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ButterflyGraph\"\>", 
       2->"\<\"Hypercube\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CubeConnectedCycle", "ObjectName",
 CellID->4568],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CubeConnectedCycle", "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the graph obtained by replacing each vertex in \
a ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     "-dimensional hypercube by a cycle of length ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     ". Cube-connected cycles share many properties with hypercubes but have \
the additional desirable property that for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"d", ">", "1"}], TraditionalForm]], "InlineMath"],
     " every vertex has degree ",
     Cell[BoxData[
      FormBox["3", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7030]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3406],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButterflyGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ButterflyGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypercube",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Hypercube"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27777086],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->102818815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->85798871]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CubeConnectedCycle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 50.3820704}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CubeConnectedCycle[d] returns the graph obtained by replacing each \
vertex in a d-dimensional hypercube by a cycle of length d. Cube-connected \
cycles share many properties with hypercubes but have the additional \
desirable property that for d > 1 every vertex has degree 3.", 
    "synonyms" -> {}, "title" -> "CubeConnectedCycle", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/CubeConnectedCycle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1901, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2524, 76, 55, 1, 70, "ObjectName",
 CellID->4568],
Cell[2582, 79, 959, 27, 70, "Usage",
 CellID->7030]
}, Open  ]],
Cell[CellGroupData[{
Cell[3578, 111, 310, 9, 70, "SeeAlsoSection",
 CellID->3406],
Cell[3891, 122, 493, 17, 70, "SeeAlso",
 CellID->17804]
}, Open  ]],
Cell[CellGroupData[{
Cell[4421, 144, 317, 9, 70, "TutorialsSection",
 CellID->27777086],
Cell[4741, 155, 187, 4, 70, "Tutorials",
 CellID->102818815]
}, Open  ]],
Cell[CellGroupData[{
Cell[4965, 164, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5287, 175, 153, 3, 70, "MoreAbout",
 CellID->85798871]
}, Open  ]],
Cell[5455, 181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

