(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7452,        250]
NotebookOptionsPosition[      5711,        196]
NotebookOutlinePosition[      6824,        226]
CellTagsIndexPosition[      6781,        223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CycleIndex" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/CycleIndex"], 
          "Orbits" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Orbits"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CycleIndex\"\>", 
       2->"\<\"Orbits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CycleStructure", "ObjectName",
 CellID->25858],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CycleStructure", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the monomial in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "[", "1", "]"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "[", "2", "]"}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["\[Ellipsis]", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["x", "TI"], "[", 
        RowBox[{
         RowBox[{
          ButtonBox["Length",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/Length"], "["}], 
         StyleBox["p", "TI"]}], "]"}], "]"}]], "InlineFormula"],
     " that is the cycle structure of the permutation ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20543]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29662],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CycleIndex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/CycleIndex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Orbits",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Orbits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22863]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->364779734],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->48536444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->250683877]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CycleStructure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 51.3977214}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "CycleStructure[p, x] returns the monomial in x[1], x[2], ..., x[Length[ \
p]] that is the cycle structure of the permutation p.", "synonyms" -> {}, 
    "title" -> "CycleStructure", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/CycleStructure"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1898, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2521, 77, 52, 1, 70, "ObjectName",
 CellID->25858],
Cell[2576, 80, 1199, 39, 70, "Usage",
 CellID->20543]
}, Open  ]],
Cell[CellGroupData[{
Cell[3812, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->29662],
Cell[4126, 135, 479, 17, 70, "SeeAlso",
 CellID->22863]
}, Open  ]],
Cell[CellGroupData[{
Cell[4642, 157, 318, 9, 70, "TutorialsSection",
 CellID->364779734],
Cell[4963, 168, 186, 4, 70, "Tutorials",
 CellID->48536444]
}, Open  ]],
Cell[CellGroupData[{
Cell[5186, 177, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5508, 188, 161, 3, 70, "MoreAbout",
 CellID->250683877]
}, Open  ]],
Cell[5684, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

