(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7956,        257]
NotebookOptionsPosition[      6104,        201]
NotebookOutlinePosition[      7269,        231]
CellTagsIndexPosition[      7226,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeBruijnGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/DeBruijnGraph"], 
          "EulerianCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/EulerianCycle"], 
          "Strings" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Strings"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DeBruijnGraph\"\>", 
       2->"\<\"EulerianCycle\"\>", 3->"\<\"Strings\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"], 
          "Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cycles and Connectivity\"\>", 
       2->"\<\"Subsets and Cycles\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeBruijnSequence", "ObjectName",
 CellID->15651],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeBruijnSequence", "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a De Bruijn sequence on the alphabet ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     ", a shortest sequence in which every string of length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " on alphabet ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " occurs as a contiguous subsequence."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17554]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27829],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeBruijnGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeBruijnGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerianCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EulerianCycle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Strings",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Strings"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3243]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->101552504],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->14531849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->506262479],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->32601710]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeBruijnSequence - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 58.7260340}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeBruijnSequence[a, n] returns a De Bruijn sequence on the alphabet a, a \
shortest sequence in which every string of length n on alphabet a occurs as a \
contiguous subsequence.", "synonyms" -> {}, "title" -> "DeBruijnSequence", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/DeBruijnSequence"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2233, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2856, 83, 54, 1, 70, "ObjectName",
 CellID->15651],
Cell[2913, 86, 806, 23, 70, "Usage",
 CellID->17554]
}, Open  ]],
Cell[CellGroupData[{
Cell[3756, 114, 311, 9, 70, "SeeAlsoSection",
 CellID->27829],
Cell[4070, 125, 755, 26, 70, "SeeAlso",
 CellID->3243]
}, Open  ]],
Cell[CellGroupData[{
Cell[4862, 156, 318, 9, 70, "TutorialsSection",
 CellID->101552504],
Cell[5183, 167, 186, 4, 70, "Tutorials",
 CellID->14531849]
}, Open  ]],
Cell[CellGroupData[{
Cell[5406, 176, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5728, 187, 172, 4, 70, "MoreAbout",
 CellID->506262479],
Cell[5903, 193, 159, 3, 70, "MoreAbout",
 CellID->32601710]
}, Open  ]],
Cell[6077, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

