(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8702,        279]
NotebookOptionsPosition[      6622,        221]
NotebookOutlinePosition[      8076,        255]
CellTagsIndexPosition[      8033,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AddEdges" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AddEdges"], 
          "DeleteVertex" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DeleteVertex"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"AddEdges\"\>", 
       2->"\<\"DeleteVertex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteEdges", "ObjectName",
 CellID->14293],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DeleteEdges", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["edgeList", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " minus the list of edges ",
     Cell[BoxData[
      StyleBox["edgeList", "TI"]], "InlineFormula"],
     ". If ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " is undirected, then the edges in ",
     Cell[BoxData[
      StyleBox["edgeList", "TI"]], "InlineFormula"],
     " are treated as undirected edges, otherwise they are treated as \
directed edges. If there are multiple edges that qualify, then only one edge \
is deleted. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"DeleteEdges", "["}], 
       StyleBox["g", "TI"], ",", 
       StyleBox["edgeList", "TI"], ",", 
       RowBox[{
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"], "]"}]}]], "InlineFormula"],
     "\[LineSeparator]will delete all edges that qualify. If only one edge is \
to be deleted, then ",
     Cell[BoxData[
      StyleBox["edgeList", "TI"]], "InlineFormula"],
     " can have the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"s", ",", "t"}], "}"}], TraditionalForm]], "InlineMath"],
     ", otherwise it has the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["s", "1"], ",", 
           SubscriptBox["t", "1"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["s", "2"], ",", 
           SubscriptBox["t", "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7196]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18328],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AddEdges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteVertex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DeleteVertex"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->39304652],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->791579108]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->68261247]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteEdges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 48, 59.8666882}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DeleteEdges[g, edgeList] gives graph g minus the list of edges edgeList. \
If g is undirected, then the edges in edgeList are treated as undirected \
edges, otherwise they are treated as directed edges. If there are multiple \
edges that qualify, then only one edge is deleted. DeleteEdges[ g, edgeList, \
All] will delete all edges that qualify. If only one edge is to be deleted, \
then edgeList can have the form {s, t}, otherwise it has the form {{s_1, \
t_1}, {s_2, t_2}, ...}.", "synonyms" -> {}, "title" -> "DeleteEdges", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/DeleteEdges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1924, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2547, 78, 49, 1, 70, "ObjectName",
 CellID->14293],
Cell[2599, 81, 2078, 63, 70, "Usage",
 CellID->7196]
}, Open  ]],
Cell[CellGroupData[{
Cell[4714, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->18328],
Cell[5028, 160, 487, 17, 70, "SeeAlso",
 CellID->23288]
}, Open  ]],
Cell[CellGroupData[{
Cell[5552, 182, 317, 9, 70, "TutorialsSection",
 CellID->39304652],
Cell[5872, 193, 187, 4, 70, "Tutorials",
 CellID->791579108]
}, Open  ]],
Cell[CellGroupData[{
Cell[6096, 202, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6418, 213, 162, 3, 70, "MoreAbout",
 CellID->68261247]
}, Open  ]],
Cell[6595, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

