(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7595,        240]
NotebookOptionsPosition[      5564,        182]
NotebookOutlinePosition[      6969,        216]
CellTagsIndexPosition[      6926,        213]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BreadthFirstTraversal" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BreadthFirstTraversal"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"BreadthFirstTraversal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DepthFirstTraversal", "ObjectName",
 CellID->31188],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DepthFirstTraversal", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a depth-first traversal of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " starting from vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     ", and gives a list of vertices in the order in which they were \
encountered. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DepthFirstTraversal", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"], ",", "Edge"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the edges of the graph that are traversed by \
the depth-first traversal in the order in which they are traversed. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DepthFirstTraversal", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"], ",", "Tree"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the depth-first tree of the graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18880],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BreadthFirstTraversal",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/BreadthFirstTraversal"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->9487]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->879222442],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->44329031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->117204245]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DepthFirstTraversal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 6.9137436}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DepthFirstTraversal[g, v] performs a depth-first traversal of graph g \
starting from vertex v, and gives a list of vertices in the order in which \
they were encountered. DepthFirstTraversal[g, v, Edge] returns the edges of \
the graph that are traversed by the depth-first traversal in the order in \
which they are traversed. DepthFirstTraversal[g, v, Tree] returns the \
depth-first tree of the graph.", "synonyms" -> {}, "title" -> 
    "DepthFirstTraversal", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DepthFirstTraversal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1812, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2435, 75, 57, 1, 70, "ObjectName",
 CellID->31188],
Cell[2495, 78, 1381, 38, 70, "Usage",
 CellID->30073]
}, Open  ]],
Cell[CellGroupData[{
Cell[3913, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->18880],
Cell[4227, 132, 235, 6, 70, "SeeAlso",
 CellID->9487]
}, Open  ]],
Cell[CellGroupData[{
Cell[4499, 143, 318, 9, 70, "TutorialsSection",
 CellID->879222442],
Cell[4820, 154, 186, 4, 70, "Tutorials",
 CellID->44329031]
}, Open  ]],
Cell[CellGroupData[{
Cell[5043, 163, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5365, 174, 157, 3, 70, "MoreAbout",
 CellID->117204245]
}, Open  ]],
Cell[5537, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

