(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6864,        220]
NotebookOptionsPosition[      5122,        170]
NotebookOutlinePosition[      6401,        202]
CellTagsIndexPosition[      6358,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListNecklaces" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ListNecklaces"], 
          "NecklacePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NecklacePolynomial"], 
          "NumberOfNecklaces" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfNecklaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListNecklaces\"\>", 
       2->"\<\"NecklacePolynomial\"\>", 
       3->"\<\"NumberOfNecklaces\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dihedral", "ObjectName",
 CellID->25808],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Dihedral"], "InlineFormula"],
     "\[LineSeparator]is an argument to the Polya-theoretic functions ",
     Cell[BoxData[
      ButtonBox["ListNecklaces",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/ListNecklaces"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["NumberOfNecklaces",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["NecklacePolynomial",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"]], 
      "InlineFormula"],
     ", which count or enumerate distinct necklaces. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData["Dihedral"], "InlineFormula"],
     "\[LineSeparator]refers to the dihedral group acting on necklaces to \
make equivalent necklaces that can be obtained from each other by a rotation \
or a flip."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30259]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21003],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ListNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NecklacePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NecklacePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->576612786],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->24468718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dihedral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 14.3670594}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Dihedral is an argument to the Polya-theoretic functions ListNecklaces, \
NumberOfNecklaces, and NecklacePolynomial, which count or enumerate distinct \
necklaces. Dihedral refers to the dihedral group acting on necklaces to make \
equivalent necklaces that can be obtained from each other by a rotation or a \
flip.", "synonyms" -> {}, "title" -> "Dihedral", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Dihedral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1529, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2152, 66, 46, 1, 70, "ObjectName",
 CellID->25808],
Cell[2201, 69, 1199, 34, 70, "Usage",
 CellID->30259]
}, Open  ]],
Cell[CellGroupData[{
Cell[3437, 108, 311, 9, 70, "SeeAlsoSection",
 CellID->21003],
Cell[3751, 119, 785, 26, 70, "SeeAlso",
 CellID->9001]
}, Open  ]],
Cell[CellGroupData[{
Cell[4573, 150, 318, 9, 70, "TutorialsSection",
 CellID->576612786],
Cell[4894, 161, 186, 4, 70, "Tutorials",
 CellID->24468718]
}, Open  ]],
Cell[5095, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

