(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7083,        235]
NotebookOptionsPosition[      5352,        181]
NotebookOutlinePosition[      6456,        211]
CellTagsIndexPosition[      6413,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BreadthFirstTraversal" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/BreadthFirstTraversal"], "ShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BreadthFirstTraversal\"\>", 
       2->"\<\"ShortestPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Distances", "ObjectName",
 CellID->17867],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Distances", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the distances in nondecreasing order from \
vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " to all vertices in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ", treating ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " as an unweighted graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13441],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BreadthFirstTraversal",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/BreadthFirstTraversal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6530]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->47974324],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->1018452552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->292330229]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Distances - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 15.1014532}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Distances[g, v] returns the distances in nondecreasing order from vertex \
v to all vertices in g, treating g as an unweighted graph.", "synonyms" -> {},
     "title" -> "Distances", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Distances"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1947, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2570, 77, 47, 1, 70, "ObjectName",
 CellID->17867],
Cell[2620, 80, 766, 24, 70, "Usage",
 CellID->14302]
}, Open  ]],
Cell[CellGroupData[{
Cell[3423, 109, 311, 9, 70, "SeeAlsoSection",
 CellID->13441],
Cell[3737, 120, 512, 17, 70, "SeeAlso",
 CellID->6530]
}, Open  ]],
Cell[CellGroupData[{
Cell[4286, 142, 317, 9, 70, "TutorialsSection",
 CellID->47974324],
Cell[4606, 153, 188, 4, 70, "Tutorials",
 CellID->1018452552]
}, Open  ]],
Cell[CellGroupData[{
Cell[4831, 162, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5153, 173, 157, 3, 70, "MoreAbout",
 CellID->292330229]
}, Open  ]],
Cell[5325, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

