(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8642,        276]
NotebookOptionsPosition[      6604,        218]
NotebookOutlinePosition[      8014,        252]
CellTagsIndexPosition[      7971,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HasseDiagram" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/HasseDiagram"], 
          "Partitions" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Partitions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"HasseDiagram\"\>", 
       2->"\<\"Partitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DominationLattice", "ObjectName",
 CellID->21568],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DominationLattice", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a Hasse diagram of the partially ordered set on \
integer partitions of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in which ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "<", "q"}], TraditionalForm]], "InlineMath"],
     " if ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     " dominates ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ". The function takes two options: ",
     Cell[BoxData["Type"], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     ", with default values ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", respectively. When ",
     Cell[BoxData["Type"], "InlineFormula"],
     " is set to ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     ", the function produces the underlying directed acyclic graph. When ",
     Cell[BoxData[
      ButtonBox["VertexLabel",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
     
     " is set to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", labels are produced for the vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14455],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HasseDiagram",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HasseDiagram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partitions",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Partitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16328604],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->258210444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->452193311]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DominationLattice - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 22.4453912}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "DominationLattice[n] returns a Hasse diagram of the partially ordered \
set on integer partitions of n in which p < q if q dominates p. The function \
takes two options: Type and VertexLabel, with default values Undirected and \
False, respectively. When Type is set to Directed, the function produces the \
underlying directed acyclic graph. When VertexLabel is set to True, labels \
are produced for the vertices.", "synonyms" -> {}, "title" -> 
    "DominationLattice", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/DominationLattice"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1902, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2525, 76, 55, 1, 70, "ObjectName",
 CellID->21568],
Cell[2583, 79, 2077, 62, 70, "Usage",
 CellID->13213]
}, Open  ]],
Cell[CellGroupData[{
Cell[4697, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->14455],
Cell[5011, 157, 491, 17, 70, "SeeAlso",
 CellID->12218]
}, Open  ]],
Cell[CellGroupData[{
Cell[5539, 179, 317, 9, 70, "TutorialsSection",
 CellID->16328604],
Cell[5859, 190, 187, 4, 70, "Tutorials",
 CellID->258210444]
}, Open  ]],
Cell[CellGroupData[{
Cell[6083, 199, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6405, 210, 157, 3, 70, "MoreAbout",
 CellID->452193311]
}, Open  ]],
Cell[6577, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

