(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11136,        343]
NotebookOptionsPosition[      8648,        278]
NotebookOutlinePosition[     10448,        317]
CellTagsIndexPosition[     10405,        314]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Isomorphism" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Isomorphism"], 
          "NumberOf2Paths" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOf2Paths"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Isomorphism\"\>", 
       2->"\<\"NumberOf2Paths\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Graph Algorithms\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Equivalences", "ObjectName",
 CellID->6363],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Equivalences", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists the vertex equivalence classes between graphs ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     " defined by their vertex degrees. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Equivalences", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]lists the vertex equivalences for graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " defined by the vertex degrees. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Equivalences", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"Equivalences", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]can also be used, where ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["f", "1"], ",", 
        SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " are functions that compute other vertex invariants. It is expected \
that for each function ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
     ", the call ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["f", "i"], "[", 
        RowBox[{"g", ",", "v"}], "]"}], TraditionalForm]], "InlineMath"],
     " returns the corresponding invariant at vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". The functions ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["f", "1"], ",", 
        SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     " are evaluated in order, and the evaluation stops either when all \
functions have been evaluated or when an empty equivalence class is found. \
Three vertex invariants, ",
     Cell[BoxData[
      ButtonBox["DegreesOf2Neighborhood",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/DegreesOf2Neighborhood"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["NumberOf2Paths",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/NumberOf2Paths"]], 
      "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["Distances",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Distances"]], "InlineFormula"],
     " are ",
     StyleBox["Combinatorica",
      FontSlant->"Italic"],
     " functions and can be used to refine the equivalences."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14450],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Isomorphism",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Isomorphism"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOf2Paths",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOf2Paths"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28367103],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->120398705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->196110778],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->443536105]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equivalences - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 38.7426834}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Equivalences[g, h] lists the vertex equivalence classes between graphs g \
and h defined by their vertex degrees. Equivalences[g] lists the vertex \
equivalences for graph g defined by the vertex degrees. Equivalences[g, h, \
f_1, f_2, ...] and Equivalences[g, f_1, f_2, ...] can also be used, where \
f_1, f_2, ... are functions that compute other vertex invariants. It is \
expected that for each function f_i, the call f_i[g, v] returns the \
corresponding invariant at vertex v in graph g. The functions f_1, f_2, ... \
are evaluated in order, and the evaluation stops either when all functions \
have been evaluated or when an empty equivalence class is found. Three vertex \
invariants, DegreesOf2Neighborhood, NumberOf2Paths, and Distances are \
Combinatorica functions and can be used to refine the equivalences.", 
    "synonyms" -> {}, "title" -> "Equivalences", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Equivalences"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2148, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2771, 82, 49, 1, 70, "ObjectName",
 CellID->6363],
Cell[2823, 85, 3669, 109, 70, "Usage",
 CellID->5845]
}, Open  ]],
Cell[CellGroupData[{
Cell[6529, 199, 311, 9, 70, "SeeAlsoSection",
 CellID->14450],
Cell[6843, 210, 496, 17, 70, "SeeAlso",
 CellID->2099]
}, Open  ]],
Cell[CellGroupData[{
Cell[7376, 232, 317, 9, 70, "TutorialsSection",
 CellID->28367103],
Cell[7696, 243, 187, 4, 70, "Tutorials",
 CellID->120398705]
}, Open  ]],
Cell[CellGroupData[{
Cell[7920, 252, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8242, 263, 157, 3, 70, "MoreAbout",
 CellID->196110778],
Cell[8402, 268, 204, 5, 70, "MoreAbout",
 CellID->443536105]
}, Open  ]],
Cell[8621, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

