(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7342,        243]
NotebookOptionsPosition[      5636,        190]
NotebookOutlinePosition[      6716,        219]
CellTagsIndexPosition[      6673,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NthPair" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/NthPair"], 
          "RandomGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/RandomGraph"], 
          "RealizeDegreeSequence" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RealizeDegreeSequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NthPair\"\>", 
       2->"\<\"RandomGraph\"\>", 
       3->"\<\"RealizeDegreeSequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ExactRandomGraph", "ObjectName",
 CellID->3127],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ExactRandomGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["e", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a random labeled graph of exactly ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " edges and ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26806]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29352],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NthPair",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NthPair"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealizeDegreeSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RealizeDegreeSequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20883]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->498012088],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->656152791]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->49133040]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ExactRandomGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 39.6177058}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ExactRandomGraph[n, e] constructs a random labeled graph of exactly e \
edges and n vertices.", "synonyms" -> {}, "title" -> "ExactRandomGraph", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/ExactRandomGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2087, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2710, 81, 53, 1, 70, "ObjectName",
 CellID->3127],
Cell[2766, 84, 643, 20, 70, "Usage",
 CellID->26806]
}, Open  ]],
Cell[CellGroupData[{
Cell[3446, 109, 311, 9, 70, "SeeAlsoSection",
 CellID->29352],
Cell[3760, 120, 768, 26, 70, "SeeAlso",
 CellID->20883]
}, Open  ]],
Cell[CellGroupData[{
Cell[4565, 151, 318, 9, 70, "TutorialsSection",
 CellID->498012088],
Cell[4886, 162, 187, 4, 70, "Tutorials",
 CellID->656152791]
}, Open  ]],
Cell[CellGroupData[{
Cell[5110, 171, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5432, 182, 162, 3, 70, "MoreAbout",
 CellID->49133040]
}, Open  ]],
Cell[5609, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

