(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8330,        265]
NotebookOptionsPosition[      6330,        208]
NotebookOutlinePosition[      7702,        241]
CellTagsIndexPosition[      7659,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToAdjacencyLists" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToAdjacencyLists"], "ToOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToOrderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ToAdjacencyLists\"\>", 
       2->"\<\"ToOrderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromAdjacencyLists", "ObjectName",
 CellID->32253],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyLists", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an edge list representation for a graph from \
the given adjacency lists ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", using a circular embedding. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyLists", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " as the embedding for the resulting graph. An option called ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on the values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " can be used to affect the type of graph produced. The default value of \
",
     Cell[BoxData["Type"], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26614],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAdjacencyLists",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToAdjacencyLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->268036464],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->48155166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->468771395]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromAdjacencyLists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 47.9460440}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FromAdjacencyLists[l] constructs an edge list representation for a graph \
from the given adjacency lists l, using a circular embedding. \
FromAdjacencyLists[l, v] uses v as the embedding for the resulting graph. An \
option called Type that takes on the values Directed or Undirected can be \
used to affect the type of graph produced. The default value of Type is \
Undirected.", "synonyms" -> {}, "title" -> "FromAdjacencyLists", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/FromAdjacencyLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2005, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2628, 79, 56, 1, 70, "ObjectName",
 CellID->32253],
Cell[2687, 82, 1636, 47, 70, "Usage",
 CellID->10792]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 134, 311, 9, 70, "SeeAlsoSection",
 CellID->26614],
Cell[4674, 145, 507, 17, 70, "SeeAlso",
 CellID->24555]
}, Open  ]],
Cell[CellGroupData[{
Cell[5218, 167, 318, 9, 70, "TutorialsSection",
 CellID->268036464],
Cell[5539, 178, 186, 4, 70, "Tutorials",
 CellID->48155166]
}, Open  ]],
Cell[CellGroupData[{
Cell[5762, 187, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6084, 198, 204, 5, 70, "MoreAbout",
 CellID->468771395]
}, Open  ]],
Cell[6303, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

