(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9710,        297]
NotebookOptionsPosition[      7400,        236]
NotebookOutlinePosition[      9083,        273]
CellTagsIndexPosition[      9040,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IncidenceMatrix" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/IncidenceMatrix"], "ToAdjacencyMatrix" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToAdjacencyMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"IncidenceMatrix\"\>", 
       2->"\<\"ToAdjacencyMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromAdjacencyMatrix", "ObjectName",
 CellID->22327],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyMatrix", "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a graph from a given adjacency matrix ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     ", using a circular embedding. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyMatrix", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " as the embedding for the resulting graph. An option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on the values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " can be used to affect the type of graph produced. The default value of \
",
     Cell[BoxData["Type"], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyMatrix", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", "EdgeWeight"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]interprets the entries in ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " as edge weights, with infinity representing missing edges, and from \
this constructs a weighted graph using a circular embedding. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromAdjacencyMatrix", "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["v", "TI"], ",", "EdgeWeight"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " as the embedding for the resulting graph. The option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " can be used along with the ",
     Cell[BoxData[
      ButtonBox["EdgeWeight",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/EdgeWeight"]], "InlineFormula"],
     " tag."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3702]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30818],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncidenceMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IncidenceMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAdjacencyMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToAdjacencyMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29003]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->416123343],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->234133006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->39583355]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromAdjacencyMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 54.3837088}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FromAdjacencyMatrix[m] constructs a graph from a given adjacency matrix \
m, using a circular embedding. FromAdjacencyMatrix[m, v] uses v as the \
embedding for the resulting graph. An option Type that takes on the values \
Directed or Undirected can be used to affect the type of graph produced. The \
default value of Type is Undirected. FromAdjacencyMatrix[m, EdgeWeight] \
interprets the entries in m as edge weights, with infinity representing \
missing edges, and from this constructs a weighted graph using a circular \
embedding. FromAdjacencyMatrix[m, v, EdgeWeight] uses v as the embedding for \
the resulting graph. The option Type can be used along with the EdgeWeight \
tag.", "synonyms" -> {}, "title" -> "FromAdjacencyMatrix", "type" -> "Symbol",
     "uri" -> "Combinatorica/ref/FromAdjacencyMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2011, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2634, 79, 57, 1, 70, "ObjectName",
 CellID->22327],
Cell[2694, 82, 2695, 75, 70, "Usage",
 CellID->3702]
}, Open  ]],
Cell[CellGroupData[{
Cell[5426, 162, 311, 9, 70, "SeeAlsoSection",
 CellID->30818],
Cell[5740, 173, 511, 17, 70, "SeeAlso",
 CellID->29003]
}, Open  ]],
Cell[CellGroupData[{
Cell[6288, 195, 318, 9, 70, "TutorialsSection",
 CellID->416123343],
Cell[6609, 206, 187, 4, 70, "Tutorials",
 CellID->234133006]
}, Open  ]],
Cell[CellGroupData[{
Cell[6833, 215, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7155, 226, 203, 5, 70, "MoreAbout",
 CellID->39583355]
}, Open  ]],
Cell[7373, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

