(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9015,        285]
NotebookOptionsPosition[      6983,        227]
NotebookOutlinePosition[      8387,        261]
CellTagsIndexPosition[      8344,        258]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromUnorderedPairs"], "ToOrderedPairs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ToOrderedPairs"],
           "ToUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToUnorderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromUnorderedPairs\"\>", 
       2->"\<\"ToOrderedPairs\"\>", 
       3->"\<\"ToUnorderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromOrderedPairs", "ObjectName",
 CellID->21020],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromOrderedPairs", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an edge list representation from a list of \
ordered pairs ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", using a circular embedding. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromOrderedPairs", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " as the embedding for the resulting graph. The option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on values ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " can be used to affect the kind of graph produced. The default value of \
",
     Cell[BoxData["Type"], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      RowBox[{"Type", "->", 
       ButtonBox["Undirected",
        BaseStyle->"Link",
        ButtonData->"paclet:Combinatorica/ref/Undirected"]}]], 
      "InlineFormula"],
     " results in the underlying undirected graph."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10165]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->336560923],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->26124201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->462262117]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromOrderedPairs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 54.9305978}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FromOrderedPairs[l] constructs an edge list representation from a list \
of ordered pairs l, using a circular embedding. FromOrderedPairs[l, v] uses v \
as the embedding for the resulting graph. The option Type that takes on \
values Undirected or Directed can be used to affect the kind of graph \
produced. The default value of Type is Directed. Type -> Undirected results \
in the underlying undirected graph.", "synonyms" -> {}, "title" -> 
    "FromOrderedPairs", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/FromOrderedPairs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2165, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2788, 82, 54, 1, 70, "ObjectName",
 CellID->21020],
Cell[2845, 85, 1852, 54, 70, "Usage",
 CellID->10165]
}, Open  ]],
Cell[CellGroupData[{
Cell[4734, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->22427],
Cell[5048, 155, 786, 26, 70, "SeeAlso",
 CellID->12054]
}, Open  ]],
Cell[CellGroupData[{
Cell[5871, 186, 318, 9, 70, "TutorialsSection",
 CellID->336560923],
Cell[6192, 197, 186, 4, 70, "Tutorials",
 CellID->26124201]
}, Open  ]],
Cell[CellGroupData[{
Cell[6415, 206, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6737, 217, 204, 5, 70, "MoreAbout",
 CellID->462262117]
}, Open  ]],
Cell[6956, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

