(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8419,        268]
NotebookOptionsPosition[      6488,        212]
NotebookOutlinePosition[      7795,        244]
CellTagsIndexPosition[      7752,        241]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromOrderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromOrderedPairs"], "ToOrderedPairs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ToOrderedPairs"],
           "ToUnorderedPairs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToUnorderedPairs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FromOrderedPairs\"\>", 
       2->"\<\"ToOrderedPairs\"\>", 
       3->"\<\"ToUnorderedPairs\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromUnorderedPairs", "ObjectName",
 CellID->1483],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromUnorderedPairs", "[", 
       StyleBox["l", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs an edge list representation from a list of \
unordered pairs ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     ", using a circular embedding."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FromUnorderedPairs", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " as the embedding for the resulting graph. The option ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on values ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " can be used to affect the kind of graph produced."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->4305]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->564],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToOrderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToOrderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUnorderedPairs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToUnorderedPairs"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24961]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->85496932],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->605904586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->608360616]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromUnorderedPairs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 55.0868518}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FromUnorderedPairs[l] constructs an edge list representation from a list \
of unordered pairs l, using a circular embedding. FromUnorderedPairs[l, v] \
uses v as the embedding for the resulting graph. The option Type that takes \
on values Undirected or Directed can be used to affect the kind of graph \
produced.", "synonyms" -> {}, "title" -> "FromUnorderedPairs", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/FromUnorderedPairs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2159, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2782, 82, 55, 1, 70, "ObjectName",
 CellID->1483],
Cell[2840, 85, 1368, 39, 70, "Usage",
 CellID->4305]
}, Open  ]],
Cell[CellGroupData[{
Cell[4245, 129, 309, 9, 70, "SeeAlsoSection",
 CellID->564],
Cell[4557, 140, 782, 26, 70, "SeeAlso",
 CellID->24961]
}, Open  ]],
Cell[CellGroupData[{
Cell[5376, 171, 317, 9, 70, "TutorialsSection",
 CellID->85496932],
Cell[5696, 182, 187, 4, 70, "Tutorials",
 CellID->605904586]
}, Open  ]],
Cell[CellGroupData[{
Cell[5920, 191, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6242, 202, 204, 5, 70, "MoreAbout",
 CellID->608360616]
}, Open  ]],
Cell[6461, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

