(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11175,        353]
NotebookOptionsPosition[      8872,        292]
NotebookOutlinePosition[     10547,        329]
CellTagsIndexPosition[     10504,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntervalGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/IntervalGraph"], 
          "MakeGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/MakeGraph"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"IntervalGraph\"\>", 
       2->"\<\"MakeGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FunctionalGraph", "ObjectName",
 CellID->28136],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FunctionalGraph", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a set ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " and a function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " and constructs a directed graph with vertex set ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " and edges ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}]}], ")"}], TraditionalForm]], 
      "InlineMath"],
     " for each ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FunctionalGraph", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a graph with vertex set ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " and edge set ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"x", ",", 
         RowBox[{
          SubscriptBox["f", "i"], "[", "x", "]"}]}], ")"}], TraditionalForm]],
       "InlineMath"],
     " for each ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["f", "i"], TraditionalForm]], "InlineMath"],
     ". An option called ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that takes on the values ",
     Cell[BoxData[
      ButtonBox["Directed",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Undirected",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
     " is allowed. ",
     Cell[BoxData[
      RowBox[{"Type", "->", 
       ButtonBox["Directed",
        BaseStyle->"Link",
        ButtonData->"paclet:Combinatorica/ref/Directed"]}]], "InlineFormula"],
     
     " is the default, while ",
     Cell[BoxData[
      RowBox[{"Type", "->", 
       ButtonBox["Undirected",
        BaseStyle->"Link",
        ButtonData->"paclet:Combinatorica/ref/Undirected"]}]], 
      "InlineFormula"],
     " returns the corresponding underlying undirected graph. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FunctionalGraph", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a nonnegative integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and a function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "\[Ellipsis]", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}], TraditionalForm]], "InlineMath"],
     " onto itself and produces the directed graph with vertex set ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "\[Ellipsis]", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}], TraditionalForm]], "InlineMath"],
     " and edge set ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}]}], "}"}], TraditionalForm]], 
      "InlineMath"],
     " for each vertex ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9097]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13409],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IntervalGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MakeGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4864]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->168192202],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->287876824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->302547205]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FunctionalGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 55.4618614}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "FunctionalGraph[f, v] takes a set v and a function f from v to v and \
constructs a directed graph with vertex set v and edges (x, f[x]) for each x \
in v. FunctionalGraph[{f_1, f_2, ...}, v] constructs a graph with vertex set \
v and edge set (x, f_i[x]) for each f_i. An option called Type that takes on \
the values Directed and Undirected is allowed. Type -> Directed is the \
default, while Type -> Undirected returns the corresponding underlying \
undirected graph. FunctionalGraph[f, n] takes a nonnegative integer n and a \
function f from {0, 1, ..., n - 1} onto itself and produces the directed \
graph with vertex set {0, 1, ..., n - 1} and edge set {x, f[x]} for each \
vertex x.", "synonyms" -> {}, "title" -> "FunctionalGraph", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/FunctionalGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1919, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2542, 77, 53, 1, 70, "ObjectName",
 CellID->28136],
Cell[2598, 80, 4324, 135, 70, "Usage",
 CellID->9097]
}, Open  ]],
Cell[CellGroupData[{
Cell[6959, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->13409],
Cell[7273, 231, 490, 17, 70, "SeeAlso",
 CellID->4864]
}, Open  ]],
Cell[CellGroupData[{
Cell[7800, 253, 318, 9, 70, "TutorialsSection",
 CellID->168192202],
Cell[8121, 264, 187, 4, 70, "Tutorials",
 CellID->287876824]
}, Open  ]],
Cell[CellGroupData[{
Cell[8345, 273, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8667, 284, 163, 3, 70, "MoreAbout",
 CellID->302547205]
}, Open  ]],
Cell[8845, 290, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

