(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8837,        288]
NotebookOptionsPosition[      6858,        231]
NotebookOutlinePosition[      8211,        264]
CellTagsIndexPosition[      8168,        261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FiniteGraphs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FiniteGraphs"], 
          "PetersenGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/PetersenGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FiniteGraphs\"\>", 
       2->"\<\"PetersenGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Built-in Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralizedPetersenGraph", "ObjectName",
 CellID->32428],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralizedPetersenGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the generalized Petersen graph, for integers ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", ">", "1"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"k", ">", "0"}], TraditionalForm]], "InlineMath"],
     ", which is the graph with vertices ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["u", "1"], ",", 
         SubscriptBox["u", "2"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["u", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["v", "1"], ",", 
         SubscriptBox["v", "2"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["v", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
     " and edges ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["u", "i"], ",", 
          RowBox[{"u", 
           RowBox[{"(", 
            RowBox[{"i", "+", "1"}], ")"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["v", "i"], ",", 
          RowBox[{"v", 
           RowBox[{"(", 
            RowBox[{"i", "+", "k"}], ")"}]}]}], "}"}]}], TraditionalForm]], 
      "InlineMath"],
     ", and ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     ". The Petersen graph is identical to the generalized Petersen graph \
with ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "=", "5"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"k", "=", "2"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19535],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FiniteGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FiniteGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PetersenGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/PetersenGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5728325],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->721377240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->207709753]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralizedPetersenGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 49, 55.6337408}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GeneralizedPetersenGraph[n, k] returns the generalized Petersen graph, \
for integers n > 1 and k > 0, which is the graph with vertices {u_1, u_2, \
..., u_n} and {v_1, v_2, ..., v_n} and edges {u_i, u (i + 1)}, {v_i, v (i + \
k)}, and {u_i, v_i}. The Petersen graph is identical to the generalized \
Petersen graph with n = 5 and k = 2.", "synonyms" -> {}, "title" -> 
    "GeneralizedPetersenGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/GeneralizedPetersenGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1918, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2541, 77, 62, 1, 70, "ObjectName",
 CellID->32428],
Cell[2606, 80, 2306, 74, 70, "Usage",
 CellID->8339]
}, Open  ]],
Cell[CellGroupData[{
Cell[4949, 159, 311, 9, 70, "SeeAlsoSection",
 CellID->19535],
Cell[5263, 170, 497, 17, 70, "SeeAlso",
 CellID->14858]
}, Open  ]],
Cell[CellGroupData[{
Cell[5797, 192, 316, 9, 70, "TutorialsSection",
 CellID->5728325],
Cell[6116, 203, 187, 4, 70, "Tutorials",
 CellID->721377240]
}, Open  ]],
Cell[CellGroupData[{
Cell[6340, 212, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6662, 223, 154, 3, 70, "MoreAbout",
 CellID->207709753]
}, Open  ]],
Cell[6831, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

