(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7081,        238]
NotebookOptionsPosition[      5370,        183]
NotebookOutlinePosition[      6394,        212]
CellTagsIndexPosition[      6351,        209]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/FindCycle"], 
          "ShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindCycle\"\>", 
       2->"\<\"ShortestPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"], 
          "Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cycles and Connectivity\"\>", 
       2->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Girth", "ObjectName",
 CellID->10601],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Girth", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the length of a shortest cycle in a simple graph \
",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13519],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FindCycle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortestPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->38441944],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->329416777]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->232706856],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->271174432]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Girth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 2.8526756}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Girth[g] gives the length of a shortest cycle in a simple graph g.", 
    "synonyms" -> {}, "title" -> "Girth", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Girth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2097, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2720, 81, 43, 1, 70, "ObjectName",
 CellID->10601],
Cell[2766, 84, 488, 16, 70, "Usage",
 CellID->3828]
}, Open  ]],
Cell[CellGroupData[{
Cell[3291, 105, 311, 9, 70, "SeeAlsoSection",
 CellID->13519],
Cell[3605, 116, 488, 17, 70, "SeeAlso",
 CellID->8773]
}, Open  ]],
Cell[CellGroupData[{
Cell[4130, 138, 317, 9, 70, "TutorialsSection",
 CellID->38441944],
Cell[4450, 149, 187, 4, 70, "Tutorials",
 CellID->329416777]
}, Open  ]],
Cell[CellGroupData[{
Cell[4674, 158, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4996, 169, 172, 4, 70, "MoreAbout",
 CellID->232706856],
Cell[5171, 175, 157, 3, 70, "MoreAbout",
 CellID->271174432]
}, Open  ]],
Cell[5343, 181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

