(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17528,        609]
NotebookOptionsPosition[     14886,        525]
NotebookOutlinePosition[     16054,        556]
CellTagsIndexPosition[     16011,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromAdjacencyLists" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromAdjacencyLists"], 
          "FromAdjacencyMatrix" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/FromAdjacencyMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FromAdjacencyLists\"\>", 
       2->"\<\"FromAdjacencyMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Graph", "ObjectName",
 CellID->9410],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Graph", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a graph object where ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " is the list of edges annotated with graphics options, ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " is a list of vertices annotated with graphics options, and ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"],
     " is a set of global graph options."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 " has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["i", "1"], ",", 
         SubscriptBox["j", "1"]}], "}"}], ",", 
       SubscriptBox[
        StyleBox["opts", "TI"], "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["i", "2"], ",", 
         SubscriptBox["j", "2"]}], "}"}], ",", 
       SubscriptBox[
        StyleBox["opts", "TI"], "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "1"], ",", 
      SubscriptBox["j", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "2"], ",", 
      SubscriptBox["j", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
   TraditionalForm]], "InlineMath"],
 " are edges of the graph and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["opts", "TI"], "1"], ",", 
    SubscriptBox[
     StyleBox["opts", "TI"], "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " are options that respectively apply to these edges."
}], "Notes",
 CellID->48504063],

Cell[TextData[{
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "1"], ",", 
         SubscriptBox["y", "1"]}], "}"}], ",", 
       SubscriptBox[
        StyleBox["opts", "TI"], "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["x", "2"], ",", 
         SubscriptBox["y", "2"]}], "}"}], ",", 
       SubscriptBox[
        StyleBox["opts", "TI"], "2"]}], "}"}], ",", "\[Ellipsis]"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "1"], ",", 
      SubscriptBox["y", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["x", "2"], ",", 
      SubscriptBox["y", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
   TraditionalForm]], "InlineMath"],
 " respectively denote the coordinates in the plane of vertex 1, vertex 2, ",
 Cell[BoxData[
  FormBox["\[Ellipsis]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["opts", "TI"], "1"], ",", 
    SubscriptBox[
     StyleBox["opts", "TI"], "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " are options that respectively apply to these vertices. "
}], "Notes",
 CellID->178362602],

Cell[TextData[{
 "Permitted edge options are ",
 Cell[BoxData[
  ButtonBox["EdgeWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabelColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabelColor"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["EdgeLabelPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeLabelPosition"]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->60463474],

Cell[TextData[{
 "Permitted vertex options are ",
 Cell[BoxData[
  ButtonBox["VertexWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumber"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumberColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumberColor"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexNumberPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexNumberPosition"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexLabelColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabelColor"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["VertexLabelPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabelPosition"]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->300576382],

Cell[TextData[{
 "The third item in a ",
 Cell[BoxData["Graph"], "InlineFormula"],
 " object is ",
 Cell[BoxData[
  StyleBox["opts", "TI"]], "InlineFormula"],
 ", a sequence of zero or more global options that apply to all vertices or \
all edges or to the graph as a whole. "
}], "Notes",
 CellID->688154007],

Cell["\<\
All edge options and vertex options can be used as global options also. \
\>", "Notes",
 CellID->607374213],

Cell["\<\
If a global option and a local edge option or vertex option differ, then the \
local edge or vertex option is used for that particular edge or vertex. \
\>", "Notes",
 CellID->340716057],

Cell[TextData[{
 "In addition to these options, the following two options can be specified as \
part of the global options: ",
 Cell[BoxData[
  ButtonBox["LoopPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/LoopPosition"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeDirection",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeDirection"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->686359350],

Cell[TextData[{
 "Furthermore, all the options of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " can be used as global options in a ",
 Cell[BoxData["Graph"], "InlineFormula"],
 " object. These can be used to specify how the graph looks when it is drawn. \
"
}], "Notes",
 CellID->526454751],

Cell[TextData[{
 "Also, all options of the graphics primitive ",
 Cell[BoxData[
  ButtonBox["Arrow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Arrow"]], "InlineFormula"],
 " can also be specified as part of global graph options. These can be used \
to affect the look of arrows that represent directed edges. "
}], "Notes",
 CellID->137214675],

Cell["\<\
See the usage message of individual options to find out more about values \
these options can take on. \
\>", "Notes",
 CellID->1567973],

Cell[TextData[{
 "Whether a graph is undirected or directed is given by the option ",
 Cell[BoxData[
  ButtonBox["EdgeDirection",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeDirection"]], "InlineFormula"],
 ". This has default value ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". For undirected graphs, the edges ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "1"], ",", 
      SubscriptBox["j", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "2"], ",", 
      SubscriptBox["j", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
   TraditionalForm]], "InlineMath"],
 " have to satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["i", "1"], "<=", 
     SubscriptBox["j", "1"]}], ",", 
    RowBox[{
     SubscriptBox["i", "2"], "<=", 
     SubscriptBox["j", "2"]}], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " and for directed graphs the edges ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "1"], ",", 
      SubscriptBox["j", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["i", "2"], ",", 
      SubscriptBox["j", "2"]}], "}"}], ",", "\[Ellipsis]"}], 
   TraditionalForm]], "InlineMath"],
 " are treated as ordered pairs, each specifying the direction of the edge as \
well."
}], "Notes",
 CellID->189964370]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28252],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromAdjacencyLists",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromAdjacencyLists"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromAdjacencyMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/FromAdjacencyMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->508394337],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->5296771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->943957996]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 10.6653756}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Graph[e, v, opts] represents a graph object where e is the list of edges \
annotated with graphics options, v is a list of vertices annotated with \
graphics options, and opts is a set of global graph options.", 
    "synonyms" -> {}, "title" -> "Graph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Graph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2037, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2660, 80, 42, 1, 70, "ObjectName",
 CellID->9410],
Cell[2705, 83, 861, 24, 70, "Usage",
 CellID->5847]
}, Open  ]],
Cell[CellGroupData[{
Cell[3603, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4081, 129, 1342, 49, 70, "Notes",
 CellID->48504063],
Cell[5426, 180, 1476, 52, 70, "Notes",
 CellID->178362602],
Cell[6905, 234, 965, 34, 70, "Notes",
 CellID->60463474],
Cell[7873, 270, 1471, 52, 70, "Notes",
 CellID->300576382],
Cell[9347, 324, 309, 9, 70, "Notes",
 CellID->688154007],
Cell[9659, 335, 117, 3, 70, "Notes",
 CellID->607374213],
Cell[9779, 340, 196, 4, 70, "Notes",
 CellID->340716057],
Cell[9978, 346, 459, 14, 70, "Notes",
 CellID->686359350],
Cell[10440, 362, 429, 14, 70, "Notes",
 CellID->526454751],
Cell[10872, 378, 350, 9, 70, "Notes",
 CellID->137214675],
Cell[11225, 389, 146, 4, 70, "Notes",
 CellID->1567973],
Cell[11374, 395, 1492, 51, 70, "Notes",
 CellID->189964370]
}, Closed]],
Cell[CellGroupData[{
Cell[12903, 451, 311, 9, 70, "SeeAlsoSection",
 CellID->28252],
Cell[13217, 462, 521, 17, 70, "SeeAlso",
 CellID->21959]
}, Open  ]],
Cell[CellGroupData[{
Cell[13775, 484, 318, 9, 70, "TutorialsSection",
 CellID->508394337],
Cell[14096, 495, 185, 4, 70, "Tutorials",
 CellID->5296771]
}, Open  ]],
Cell[CellGroupData[{
Cell[14318, 504, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[14640, 515, 204, 5, 70, "MoreAbout",
 CellID->943957996]
}, Open  ]],
Cell[14859, 523, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

