(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7459,        247]
NotebookOptionsPosition[      5664,        192]
NotebookOutlinePosition[      6832,        223]
CellTagsIndexPosition[      6789,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphProduct" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphProduct"], 
          "GraphUnion" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphUnion"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GraphProduct\"\>", 
       2->"\<\"GraphUnion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphJoin", "ObjectName",
 CellID->29498],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphJoin", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs the join of graphs ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "1"], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "2"], TraditionalForm]], "InlineMath"],
     ", and so on. This is the graph obtained by adding all possible edges \
between different graphs to the graph union of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["g", "1"], ",", 
        SubscriptBox["g", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32524],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphUnion",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphUnion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->246058777],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->319530213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->8568840]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphJoin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 10.4466200}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GraphJoin[g_1, g_2, ...] constructs the join of graphs g_1, g_2, and so \
on. This is the graph obtained by adding all possible edges between different \
graphs to the graph union of g_1, g_2, ....", "synonyms" -> {}, "title" -> 
    "GraphJoin", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/GraphJoin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1919, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2542, 77, 47, 1, 70, "ObjectName",
 CellID->29498],
Cell[2592, 80, 1123, 35, 70, "Usage",
 CellID->29225]
}, Open  ]],
Cell[CellGroupData[{
Cell[3752, 120, 311, 9, 70, "SeeAlsoSection",
 CellID->32524],
Cell[4066, 131, 491, 17, 70, "SeeAlso",
 CellID->19882]
}, Open  ]],
Cell[CellGroupData[{
Cell[4594, 153, 318, 9, 70, "TutorialsSection",
 CellID->246058777],
Cell[4915, 164, 187, 4, 70, "Tutorials",
 CellID->319530213]
}, Open  ]],
Cell[CellGroupData[{
Cell[5139, 173, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5461, 184, 161, 3, 70, "MoreAbout",
 CellID->8568840]
}, Open  ]],
Cell[5637, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

