(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7407,        243]
NotebookOptionsPosition[      5562,        188]
NotebookOutlinePosition[      6781,        219]
CellTagsIndexPosition[      6738,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShortestPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ShortestPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ShortestPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphPower", "ObjectName",
 CellID->1297],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphPower", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " power of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". This is the graph whose vertex set is identical to the vertex set of \
",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and that contains an edge between vertices ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " for each path in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " between vertices ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " of length at most ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1352],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ShortestPath",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/ShortestPath"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->406943792],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->214497377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->136621968]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphPower - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 11.3685186}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GraphPower[g, k] gives the k\\[Null]^th power of graph g. This is the \
graph whose vertex set is identical to the vertex set of g and that contains \
an edge between vertices i and j for each path in g between vertices i and j \
of length at most k.", "synonyms" -> {}, "title" -> "GraphPower", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/GraphPower"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1777, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 74, 47, 1, 70, "ObjectName",
 CellID->1297],
Cell[2450, 77, 1441, 45, 70, "Usage",
 CellID->12252]
}, Open  ]],
Cell[CellGroupData[{
Cell[3928, 127, 310, 9, 70, "SeeAlsoSection",
 CellID->1352],
Cell[4241, 138, 218, 6, 70, "SeeAlso",
 CellID->18219]
}, Open  ]],
Cell[CellGroupData[{
Cell[4496, 149, 318, 9, 70, "TutorialsSection",
 CellID->406943792],
Cell[4817, 160, 187, 4, 70, "Tutorials",
 CellID->214497377]
}, Open  ]],
Cell[CellGroupData[{
Cell[5041, 169, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5363, 180, 157, 3, 70, "MoreAbout",
 CellID->136621968]
}, Open  ]],
Cell[5535, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

