(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8168,        268]
NotebookOptionsPosition[      6345,        212]
NotebookOutlinePosition[      7478,        242]
CellTagsIndexPosition[      7435,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphIntersection" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/GraphIntersection"], "GraphJoin" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphJoin"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GraphIntersection\"\>", 
       2->"\<\"GraphJoin\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Constructing Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GraphUnion", "ObjectName",
 CellID->30405],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphUnion", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the union of graphs ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "1"], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "2"], TraditionalForm]], "InlineMath"],
     ", and so forth. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GraphUnion", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["g", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " copies of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ", for any nonnegative integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30946]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5054],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphIntersection",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphIntersection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphJoin",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphJoin"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25044]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->264267222],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->123877642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->327204754],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->150259738]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphUnion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 12.3216680}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GraphUnion[g_1, g_2, ...] constructs the union of graphs g_1, g_2, and \
so forth. GraphUnion[n, g] constructs n copies of graph g, for any \
nonnegative integer n.", "synonyms" -> {}, "title" -> "GraphUnion", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/GraphUnion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2150, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2773, 81, 48, 1, 70, "ObjectName",
 CellID->30405],
Cell[2824, 84, 1356, 44, 70, "Usage",
 CellID->30946]
}, Open  ]],
Cell[CellGroupData[{
Cell[4217, 133, 310, 9, 70, "SeeAlsoSection",
 CellID->5054],
Cell[4530, 144, 499, 17, 70, "SeeAlso",
 CellID->25044]
}, Open  ]],
Cell[CellGroupData[{
Cell[5066, 166, 318, 9, 70, "TutorialsSection",
 CellID->264267222],
Cell[5387, 177, 187, 4, 70, "Tutorials",
 CellID->123877642]
}, Open  ]],
Cell[CellGroupData[{
Cell[5611, 186, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5933, 197, 163, 3, 70, "MoreAbout",
 CellID->327204754],
Cell[6099, 202, 204, 5, 70, "MoreAbout",
 CellID->150259738]
}, Open  ]],
Cell[6318, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

