(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8206,        271]
NotebookOptionsPosition[      6351,        214]
NotebookOutlinePosition[      7518,        245]
CellTagsIndexPosition[      7475,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphProduct" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphProduct"], 
          "Path" :> Documentation`HelpLookup[
           "paclet:Combinatorica/ref/Path"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphProduct\"\>", 
       2->"\<\"Path\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Built-in Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/BuiltinGraphs"], 
          "Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Built-in Graphs\"\>", 
       2->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GridGraph", "ObjectName",
 CellID->10220],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GridGraph", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "*", "m"}], TraditionalForm]], "InlineMath"],
     " grid graph, the product of paths on ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " vertices. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GridGraph", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "*", "q", "*", "r"}], TraditionalForm]], "InlineMath"],
     " grid graph, the product of ",
     Cell[BoxData[
      RowBox[{"GridGraph", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     " and a path of length ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3717]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9236],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphProduct",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphProduct"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Path",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Path"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->754039058],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->414317528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Built-in Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/BuiltinGraphs"]], "MoreAbout",
 CellID->147750930],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->47364936]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GridGraph - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 20.7906348}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "GridGraph[n, m] constructs an n*m grid graph, the product of paths on n \
and m vertices. GridGraph[p, q, r] constructs a p*q*r grid graph, the product \
of GridGraph[p, q] and a path of length r.", "synonyms" -> {}, "title" -> 
    "GridGraph", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/GridGraph"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2106, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2729, 81, 47, 1, 70, "ObjectName",
 CellID->10220],
Cell[2779, 84, 1437, 46, 70, "Usage",
 CellID->3717]
}, Open  ]],
Cell[CellGroupData[{
Cell[4253, 135, 310, 9, 70, "SeeAlsoSection",
 CellID->9236],
Cell[4566, 146, 479, 17, 70, "SeeAlso",
 CellID->21446]
}, Open  ]],
Cell[CellGroupData[{
Cell[5082, 168, 318, 9, 70, "TutorialsSection",
 CellID->754039058],
Cell[5403, 179, 187, 4, 70, "Tutorials",
 CellID->414317528]
}, Open  ]],
Cell[CellGroupData[{
Cell[5627, 188, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5949, 199, 154, 3, 70, "MoreAbout",
 CellID->147750930],
Cell[6106, 204, 203, 5, 70, "MoreAbout",
 CellID->47364936]
}, Open  ]],
Cell[6324, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

