(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8052,        262]
NotebookOptionsPosition[      6235,        206]
NotebookOutlinePosition[      7366,        236]
CellTagsIndexPosition[      7323,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerianCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/EulerianCycle"], 
          "HamiltonianQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/HamiltonianQ"], 
          "HamiltonianPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HamiltonianPath"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EulerianCycle\"\>", 2->"\<\"HamiltonianQ\"\>", 
       3->"\<\"HamiltonianPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cycles and Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/CyclesAndConnectivity"], 
          "Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cycles and Connectivity\"\>", 
       2->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HamiltonianCycle", "ObjectName",
 CellID->6271],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianCycle", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a Hamiltonian cycle in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " if one exists. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianCycle", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all Hamiltonian cycles of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3414]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30179],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerianCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EulerianCycle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->131973483],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->63295211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Cycles and Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/CyclesAndConnectivity"]], "MoreAbout",\

 CellID->254685575],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->43802087]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HamiltonianCycle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 23.6344576}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "HamiltonianCycle[g] finds a Hamiltonian cycle in graph g if one exists. \
HamiltonianCycle[g, All] gives all Hamiltonian cycles of graph g.", 
    "synonyms" -> {}, "title" -> "HamiltonianCycle", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/HamiltonianCycle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2252, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2875, 83, 53, 1, 70, "ObjectName",
 CellID->6271],
Cell[2931, 86, 907, 28, 70, "Usage",
 CellID->3414]
}, Open  ]],
Cell[CellGroupData[{
Cell[3875, 119, 311, 9, 70, "SeeAlsoSection",
 CellID->30179],
Cell[4189, 130, 770, 26, 70, "SeeAlso",
 CellID->17141]
}, Open  ]],
Cell[CellGroupData[{
Cell[4996, 161, 318, 9, 70, "TutorialsSection",
 CellID->131973483],
Cell[5317, 172, 186, 4, 70, "Tutorials",
 CellID->63295211]
}, Open  ]],
Cell[CellGroupData[{
Cell[5540, 181, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5862, 192, 172, 4, 70, "MoreAbout",
 CellID->254685575],
Cell[6037, 198, 156, 3, 70, "MoreAbout",
 CellID->43802087]
}, Open  ]],
Cell[6208, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

