(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6361,        210]
NotebookOptionsPosition[      4775,        162]
NotebookOutlinePosition[      5899,        192]
CellTagsIndexPosition[      5856,        189]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerianCycle" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/EulerianCycle"], 
          "HamiltonianPath" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HamiltonianPath"], "HamiltonianQ" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/HamiltonianQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EulerianCycle\"\>", 2->"\<\"HamiltonianPath\"\>",
        3->"\<\"HamiltonianQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HamiltonianPath", "ObjectName",
 CellID->25389],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianPath", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a Hamiltonian path in graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " if one exists. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HamiltonianPath", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all Hamiltonian paths of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1560],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerianCycle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/EulerianCycle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianPath",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HamiltonianQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HamiltonianQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->412084074],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->173557350]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HamiltonianPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 26.4314042}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "HamiltonianPath[g] finds a Hamiltonian path in graph g if one exists. \
HamiltonianPath[g, All] gives all Hamiltonian paths of graph g.", 
    "synonyms" -> {}, "title" -> "HamiltonianPath", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/HamiltonianPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1486, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2109, 64, 53, 1, 70, "ObjectName",
 CellID->25389],
Cell[2165, 67, 904, 28, 70, "Usage",
 CellID->27880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3106, 100, 310, 9, 70, "SeeAlsoSection",
 CellID->1560],
Cell[3419, 111, 769, 26, 70, "SeeAlso",
 CellID->2247]
}, Open  ]],
Cell[CellGroupData[{
Cell[4225, 142, 318, 9, 70, "TutorialsSection",
 CellID->412084074],
Cell[4546, 153, 187, 4, 70, "Tutorials",
 CellID->173557350]
}, Open  ]],
Cell[4748, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

