(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13154,        459]
NotebookOptionsPosition[     10953,        390]
NotebookOutlinePosition[     12096,        420]
CellTagsIndexPosition[     12053,        417]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AnimateGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/AnimateGraph"], 
          "ShowGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ShowGraph"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"AnimateGraph\"\>", 
       2->"\<\"ShowGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/DisplayingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Displaying Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Highlight", "ObjectName",
 CellID->7572],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Highlight", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " with elements in ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " highlighted. The second argument ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " has the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["s", "1"], ",", 
         SubscriptBox["s", "2"], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " are disjoint subsets of vertices and edges of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The options, ",
 Cell[BoxData[
  ButtonBox["HighlightedVertexStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedVertexStyle"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HighlightedEdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeStyle"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HighlightedVertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedVertexColors"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["HighlightedEdgeColors",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeColors"]], 
  "InlineFormula"],
 " are used to determine the appearance of the highlighted elements of the \
graph. "
}], "Notes",
 CellID->14322],

Cell[TextData[{
 "The default settings of the style options are ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HighlightedVertexStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HighlightedVertexStyle"], "->", 
   RowBox[{
    ButtonBox["Disk",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Disk"], "[", 
    ButtonBox["Large",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Large"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HighlightedEdgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeStyle"], "->", 
   "Thick"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->277614059],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["HighlightedVertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedVertexColors"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["HighlightedEdgeColors",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/HighlightedEdgeColors"]], 
  "InlineFormula"],
 " are both set to ",
 Cell[BoxData["{"], "InlineFormula"],
 Cell[BoxData[
  ButtonBox["Black",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Black"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Green",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Green"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Yellow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Yellow"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Purple",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Purple"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Brown",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Brown"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Orange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orange"]], "InlineFormula"],
 ", ",
 Cell[BoxData["Olive"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pink"]], "InlineFormula"],
 ", ",
 Cell[BoxData["DeepPink"], "InlineFormula"],
 ", ",
 Cell[BoxData["DarkGreen"], "InlineFormula"],
 ", ",
 Cell[BoxData["Maroon"], "InlineFormula"],
 ", ",
 Cell[BoxData["Navy"], "InlineFormula"],
 Cell[BoxData["}"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->170569120],

Cell[TextData[{
 "The colors are chosen from the palette of colors with color 1 used for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "1"], TraditionalForm]], "InlineMath"],
 ", color 2 used for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "2"], TraditionalForm]], "InlineMath"],
 ", and so on. If there are more parts than colors, then the colors are used \
cyclically. "
}], "Notes",
 CellID->401960585],

Cell[TextData[{
 "The function permits all the options that ",
 Cell[BoxData[
  ButtonBox["SetGraphOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/SetGraphOptions"]], 
  "InlineFormula"],
 " permits, for example, ",
 Cell[BoxData[
  ButtonBox["VertexColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["VertexStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexStyle"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeColor",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeColor"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["EdgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/EdgeStyle"]], "InlineFormula"],
 ". These options can be used to control the appearance of the \
non-highlighted vertices and edges."
}], "Notes",
 CellID->490531969]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25446],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnimateGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/AnimateGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ShowGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->299817446],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->544644454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Displaying Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/DisplayingGraphs"]], "MoreAbout",
 CellID->19653110]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Highlight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 35.5878886}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Highlight[g, p] displays g with elements in p highlighted. The second \
argument p has the form {s_1, s_2, ...}, where the s_i are disjoint subsets \
of vertices and edges of g.", "synonyms" -> {}, "title" -> "Highlight", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/Highlight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1910, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2533, 77, 46, 1, 70, "ObjectName",
 CellID->7572],
Cell[2582, 80, 1199, 38, 70, "Usage",
 CellID->11523]
}, Open  ]],
Cell[CellGroupData[{
Cell[3818, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4296, 140, 825, 28, 70, "Notes",
 CellID->14322],
Cell[5124, 170, 684, 23, 70, "Notes",
 CellID->277614059],
Cell[5811, 195, 1830, 72, 70, "Notes",
 CellID->170569120],
Cell[7644, 269, 415, 12, 70, "Notes",
 CellID->401960585],
Cell[8062, 283, 948, 30, 70, "Notes",
 CellID->490531969]
}, Closed]],
Cell[CellGroupData[{
Cell[9047, 318, 311, 9, 70, "SeeAlsoSection",
 CellID->25446],
Cell[9361, 329, 488, 17, 70, "SeeAlso",
 CellID->4728]
}, Open  ]],
Cell[CellGroupData[{
Cell[9886, 351, 318, 9, 70, "TutorialsSection",
 CellID->299817446],
Cell[10207, 362, 187, 4, 70, "Tutorials",
 CellID->544644454]
}, Open  ]],
Cell[CellGroupData[{
Cell[10431, 371, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[10753, 382, 158, 3, 70, "MoreAbout",
 CellID->19653110]
}, Open  ]],
Cell[10926, 388, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

