(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7971,        262]
NotebookOptionsPosition[      6113,        207]
NotebookOutlinePosition[      7345,        238]
CellTagsIndexPosition[      7302,        235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LineGraph" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/LineGraph"], 
          "ToAdjacencyMatrix" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/ToAdjacencyMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LineGraph\"\>", 
       2->"\<\"ToAdjacencyMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Construction and Representations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Graph Construction and Representations\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IncidenceMatrix", "ObjectName",
 CellID->20525],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IncidenceMatrix", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}], TraditionalForm]], "InlineMath"],
     "-matrix of graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ", which has a row for each vertex and a column for each edge and ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", ",", "e"}], ")"}], "=", "1"}], TraditionalForm]], 
      "InlineMath"],
     " if and only if vertex ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     " is incident upon edge ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     ". For a directed graph, ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"v", ",", "e"}], ")"}], "=", "1"}], TraditionalForm]], 
      "InlineMath"],
     " if edge ",
     Cell[BoxData[
      FormBox["e", TraditionalForm]], "InlineMath"],
     " is outgoing from ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22877],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LineGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/LineGraph"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAdjacencyMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ToAdjacencyMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->36304428],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->4864779]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Construction and Representations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/GraphConstructionAndRepresentations"]], \
"MoreAbout",
 CellID->213724893]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IncidenceMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 42.8536996}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "IncidenceMatrix[g] returns the (0, 1)-matrix of graph g, which has a row \
for each vertex and a column for each edge and (v, e) = 1 if and only if \
vertex v is incident upon edge e. For a directed graph, (v, e) = 1 if edge e \
is outgoing from v.", "synonyms" -> {}, "title" -> "IncidenceMatrix", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/IncidenceMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1992, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2615, 79, 53, 1, 70, "ObjectName",
 CellID->20525],
Cell[2671, 82, 1445, 46, 70, "Usage",
 CellID->13700]
}, Open  ]],
Cell[CellGroupData[{
Cell[4153, 133, 311, 9, 70, "SeeAlsoSection",
 CellID->22877],
Cell[4467, 144, 499, 17, 70, "SeeAlso",
 CellID->21526]
}, Open  ]],
Cell[CellGroupData[{
Cell[5003, 166, 317, 9, 70, "TutorialsSection",
 CellID->36304428],
Cell[5323, 177, 185, 4, 70, "Tutorials",
 CellID->4864779]
}, Open  ]],
Cell[CellGroupData[{
Cell[5545, 186, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5867, 197, 204, 5, 70, "MoreAbout",
 CellID->213724893]
}, Open  ]],
Cell[6086, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

