(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9715,        323]
NotebookOptionsPosition[      7573,        257]
NotebookOutlinePosition[      8779,        288]
CellTagsIndexPosition[      8736,        285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DominationLattice" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/DominationLattice"], 
          "MinimumChangePermutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/MinimumChangePermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DominationLattice\"\>", 
       2->"\<\"MinimumChangePermutations\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"], "Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>", 
       2->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InversionPoset", "ObjectName",
 CellID->15820],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InversionPoset", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a Hasse diagram of the partially ordered set on \
size-",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " permutations in which ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "<", "q"}], TraditionalForm]], "InlineMath"],
     " if ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     " can be obtained from ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " by an adjacent transposition that places the larger element before the \
smaller."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16055]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The function takes two options: ",
 Cell[BoxData["Type"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 ", with default values ",
 Cell[BoxData[
  ButtonBox["Undirected",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Undirected"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", respectively. "
}], "Notes",
 CellID->29841],

Cell[TextData[{
 "When ",
 Cell[BoxData["Type"], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Directed",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Directed"]], "InlineFormula"],
 ", the function produces the underlying directed acyclic graph. When ",
 Cell[BoxData[
  ButtonBox["VertexLabel",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/VertexLabel"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", labels are produced for the vertices."
}], "Notes",
 CellID->871150803]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4834],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DominationLattice",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/DominationLattice"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimumChangePermutations",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MinimumChangePermutations"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13992]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->199294255],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->30985648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->7932025],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->575010820]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InversionPoset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 50.6820250}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "InversionPoset[n] returns a Hasse diagram of the partially ordered set \
on size-n permutations in which p < q if q can be obtained from p by an \
adjacent transposition that places the larger element before the smaller.", 
    "synonyms" -> {}, "title" -> "InversionPoset", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/InversionPoset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2130, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2753, 81, 52, 1, 70, "ObjectName",
 CellID->15820],
Cell[2808, 84, 905, 27, 70, "Usage",
 CellID->16055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3750, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4228, 133, 578, 20, 70, "Notes",
 CellID->29841],
Cell[4809, 155, 630, 20, 70, "Notes",
 CellID->871150803]
}, Closed]],
Cell[CellGroupData[{
Cell[5476, 180, 310, 9, 70, "SeeAlsoSection",
 CellID->4834],
Cell[5789, 191, 531, 17, 70, "SeeAlso",
 CellID->13992]
}, Open  ]],
Cell[CellGroupData[{
Cell[6357, 213, 318, 9, 70, "TutorialsSection",
 CellID->199294255],
Cell[6678, 224, 186, 4, 70, "Tutorials",
 CellID->30985648]
}, Open  ]],
Cell[CellGroupData[{
Cell[6901, 233, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7223, 244, 155, 3, 70, "MoreAbout",
 CellID->7932025],
Cell[7381, 249, 150, 3, 70, "MoreAbout",
 CellID->575010820]
}, Open  ]],
Cell[7546, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

