(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9547,        326]
NotebookOptionsPosition[      7562,        262]
NotebookOutlinePosition[      8603,        291]
CellTagsIndexPosition[      8560,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IdenticalQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/IdenticalQ"], 
          "Isomorphism" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/Isomorphism"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"IdenticalQ\"\>", 
       2->"\<\"Isomorphism\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"], "Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>", 
       2->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IsomorphicQ", "ObjectName",
 CellID->30967],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IsomorphicQ", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if graphs ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     " are isomorphic. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20277]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This function takes an option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Invariants",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Invariants"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TI"]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], ",", 
    SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " are functions that are used to compute vertex invariants. These functions \
are used in the order in which they are specified. "
}], "Notes",
 CellID->185197517],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Invariants"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["DegreesOf2Neighborhood",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/DegreesOf2Neighborhood"], ",", 
    ButtonBox["NumberOf2Paths",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/NumberOf2Paths"], ",", 
    ButtonBox["Distances",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/Distances"]}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->172631977]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10583],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdenticalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IdenticalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Isomorphism",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Isomorphism"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->534246444],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->400856433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->108194963],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->379401236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IsomorphicQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 52.7445778}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "IsomorphicQ[g, h] yields True if graphs g and h are isomorphic. ", 
    "synonyms" -> {}, "title" -> "IsomorphicQ", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/IsomorphicQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2066, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2689, 80, 49, 1, 70, "ObjectName",
 CellID->30967],
Cell[2741, 83, 748, 25, 70, "Usage",
 CellID->20277]
}, Open  ]],
Cell[CellGroupData[{
Cell[3526, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4004, 130, 784, 26, 70, "Notes",
 CellID->185197517],
Cell[4791, 158, 668, 22, 70, "Notes",
 CellID->172631977]
}, Closed]],
Cell[CellGroupData[{
Cell[5496, 185, 311, 9, 70, "SeeAlsoSection",
 CellID->10583],
Cell[5810, 196, 489, 17, 70, "SeeAlso",
 CellID->11191]
}, Open  ]],
Cell[CellGroupData[{
Cell[6336, 218, 318, 9, 70, "TutorialsSection",
 CellID->534246444],
Cell[6657, 229, 187, 4, 70, "Tutorials",
 CellID->400856433]
}, Open  ]],
Cell[CellGroupData[{
Cell[6881, 238, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[7203, 249, 157, 3, 70, "MoreAbout",
 CellID->108194963],
Cell[7363, 254, 157, 3, 70, "MoreAbout",
 CellID->379401236]
}, Open  ]],
Cell[7535, 260, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

