(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10413,        350]
NotebookOptionsPosition[      8352,        286]
NotebookOutlinePosition[      9530,        317]
CellTagsIndexPosition[      9487,        314]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automorphisms" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Automorphisms"], 
          "IdenticalQ" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/IdenticalQ"], 
          "IsomorphicQ" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/IsomorphicQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Automorphisms\"\>", 2->"\<\"IdenticalQ\"\>", 
       3->"\<\"IsomorphicQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Isomorphism", "ObjectName",
 CellID->19355],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Isomorphism", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an isomorphism between graphs ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     " if one exists. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Isomorphism", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all isomorphisms between graphs ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["h", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Isomorphism", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the automorphism group of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This function takes an option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Invariants",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Invariants"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TI"]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], ",", 
    SubscriptBox["f", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " are functions that are used to compute vertex invariants. These functions \
are used in the order in which they are specified. "
}], "Notes",
 CellID->431966410],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["Invariants",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/Invariants"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["DegreesOf2Neighborhood",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/DegreesOf2Neighborhood"], ",", 
    ButtonBox["NumberOf2Paths",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/NumberOf2Paths"], ",", 
    ButtonBox["Distances",
     BaseStyle->"Link",
     ButtonData->"paclet:Combinatorica/ref/Distances"]}], "}"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->216547148]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16969],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automorphisms",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Automorphisms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdenticalQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IdenticalQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IsomorphicQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/IsomorphicQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->955105983],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->168047653]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->645789840]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Isomorphism - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 53.3852192}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Isomorphism[g, h] gives an isomorphism between graphs g and h if one \
exists. Isomorphism[g, h, All] gives all isomorphisms between graphs g and h. \
Isomorphism[g] gives the automorphism group of g. ", "synonyms" -> {}, 
    "title" -> "Isomorphism", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Isomorphism"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2047, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2670, 79, 49, 1, 70, "ObjectName",
 CellID->19355],
Cell[2722, 82, 1448, 46, 70, "Usage",
 CellID->24190]
}, Open  ]],
Cell[CellGroupData[{
Cell[4207, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4685, 150, 784, 26, 70, "Notes",
 CellID->431966410],
Cell[5472, 178, 668, 22, 70, "Notes",
 CellID->216547148]
}, Closed]],
Cell[CellGroupData[{
Cell[6177, 205, 311, 9, 70, "SeeAlsoSection",
 CellID->16969],
Cell[6491, 216, 758, 26, 70, "SeeAlso",
 CellID->22959]
}, Open  ]],
Cell[CellGroupData[{
Cell[7286, 247, 318, 9, 70, "TutorialsSection",
 CellID->955105983],
Cell[7607, 258, 187, 4, 70, "Tutorials",
 CellID->168047653]
}, Open  ]],
Cell[CellGroupData[{
Cell[7831, 267, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[8153, 278, 157, 3, 70, "MoreAbout",
 CellID->645789840]
}, Open  ]],
Cell[8325, 284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

