(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6623,        222]
NotebookOptionsPosition[      4902,        168]
NotebookOutlinePosition[      6000,        198]
CellTagsIndexPosition[      5957,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InversePermutation" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/InversePermutation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"InversePermutation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/Permutations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Josephus", "ObjectName",
 CellID->22511],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Josephus", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates the inverse of the permutation defined by \
executing every ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " member in a circle of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " members."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->59]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31402],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["InversePermutation",
   BaseStyle->"Link",
   ButtonData->"paclet:Combinatorica/ref/InversePermutation"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12764]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->232782200],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->64735994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutations",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/Permutations"]], "MoreAbout",
 CellID->385492884]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Josephus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 55.4008958}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "Josephus[n, m] generates the inverse of the permutation defined by \
executing every m\\[Null]^th member in a circle of n members.", 
    "synonyms" -> {}, "title" -> "Josephus", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/Josephus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1792, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2415, 75, 46, 1, 70, "ObjectName",
 CellID->22511],
Cell[2464, 78, 762, 24, 70, "Usage",
 CellID->59]
}, Open  ]],
Cell[CellGroupData[{
Cell[3263, 107, 311, 9, 70, "SeeAlsoSection",
 CellID->31402],
Cell[3577, 118, 230, 6, 70, "SeeAlso",
 CellID->12764]
}, Open  ]],
Cell[CellGroupData[{
Cell[3844, 129, 318, 9, 70, "TutorialsSection",
 CellID->232782200],
Cell[4165, 140, 186, 4, 70, "Tutorials",
 CellID->64735994]
}, Open  ]],
Cell[CellGroupData[{
Cell[4388, 149, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[4710, 160, 150, 3, 70, "MoreAbout",
 CellID->385492884]
}, Open  ]],
Cell[4875, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

