(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8120,        266]
NotebookOptionsPosition[      6237,        210]
NotebookOutlinePosition[      7494,        242]
CellTagsIndexPosition[      7451,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrbitInventory" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/OrbitInventory"],
           "SymmetricGroup" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SymmetricGroup"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"OrbitInventory\"\>", 
       2->"\<\"SymmetricGroup\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KSubsetGroup", "ObjectName",
 CellID->19406],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KSubsetGroup", "[", 
       RowBox[{
        StyleBox["pg", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the group induced by a permutation group ",
     Cell[BoxData[
      StyleBox["pg", "TI"]], "InlineFormula"],
     " on the set ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-subsets of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"[", "n", "]"}], TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " is the index of ",
     Cell[BoxData[
      StyleBox["pg", "TI"]], "InlineFormula"],
     ". The optional argument ",
     Cell[BoxData["Type"], "InlineFormula"],
     " can be ",
     Cell[BoxData[
      ButtonBox["Ordered",
       BaseStyle->"Link",
       ButtonData->"paclet:Combinatorica/ref/Ordered"]], "InlineFormula"],
     " or ",
     Cell[BoxData["Unordered"], "InlineFormula"],
     " and depending on the value of ",
     Cell[BoxData[
      RowBox[{"Type", 
       StyleBox["s", "TI"]}]], "InlineFormula"],
     " is treated as a set of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-subsets or ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-tuples."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SymmetricGroup"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->126503890],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->61088368]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->60031253]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KSubsetGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 58.9322362}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "KSubsetGroup[pg, s] returns the group induced by a permutation group pg \
on the set s of k-subsets of [n], where n is the index of pg. The optional \
argument Type can be Ordered or Unordered and depending on the value of Type \
s is treated as a set of k-subsets or k-tuples.", "synonyms" -> {}, "title" -> 
    "KSubsetGroup", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/KSubsetGroup"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1945, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2568, 78, 50, 1, 70, "ObjectName",
 CellID->19406],
Cell[2621, 81, 1658, 52, 70, "Usage",
 CellID->30164]
}, Open  ]],
Cell[CellGroupData[{
Cell[4316, 138, 311, 9, 70, "SeeAlsoSection",
 CellID->18809],
Cell[4630, 149, 502, 17, 70, "SeeAlso",
 CellID->9985]
}, Open  ]],
Cell[CellGroupData[{
Cell[5169, 171, 318, 9, 70, "TutorialsSection",
 CellID->126503890],
Cell[5490, 182, 186, 4, 70, "Tutorials",
 CellID->61088368]
}, Open  ]],
Cell[CellGroupData[{
Cell[5713, 191, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6035, 202, 160, 3, 70, "MoreAbout",
 CellID->60031253]
}, Open  ]],
Cell[6210, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

