(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7663,        247]
NotebookOptionsPosition[      5774,        191]
NotebookOutlinePosition[      7037,        223]
CellTagsIndexPosition[      6994,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrbitInventory" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/OrbitInventory"],
           "SymmetricGroupIndex" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/SymmetricGroupIndex"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrbitInventory\"\>", 
       2->"\<\"SymmetricGroupIndex\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Permutation Groups" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/PermutationGroups"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Permutation Groups\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KSubsetGroupIndex", "ObjectName",
 CellID->30773],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KSubsetGroupIndex", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the cycle index of the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     "-subset group on ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " expressed as a polynomial in ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], ",", 
        RowBox[{"x", "[", "2", "]"}], ",", "\[Ellipsis]"}], TraditionalForm]],
       "InlineMath"],
     ". This function also takes the optional argument ",
     Cell[BoxData["Type"], "InlineFormula"],
     " that tells the function whether the elements of ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " should be treated as sets or tuples."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17194]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2386],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrbitInventory",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrbitInventory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymmetricGroupIndex",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/SymmetricGroupIndex"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->354661674],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->208744827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Permutation Groups",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/PermutationGroups"]], "MoreAbout",
 CellID->65639680]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KSubsetGroupIndex - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 58.7759822}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "KSubsetGroupIndex[g, s, x] returns the cycle index of the k-subset group \
on s expressed as a polynomial in x[1], x[2], .... This function also takes \
the optional argument Type that tells the function whether the elements of s \
should be treated as sets or tuples.", "synonyms" -> {}, "title" -> 
    "KSubsetGroupIndex", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/KSubsetGroupIndex"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1960, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2583, 78, 55, 1, 70, "ObjectName",
 CellID->30773],
Cell[2641, 81, 1165, 33, 70, "Usage",
 CellID->17194]
}, Open  ]],
Cell[CellGroupData[{
Cell[3843, 119, 310, 9, 70, "SeeAlsoSection",
 CellID->2386],
Cell[4156, 130, 512, 17, 70, "SeeAlso",
 CellID->1590]
}, Open  ]],
Cell[CellGroupData[{
Cell[4705, 152, 318, 9, 70, "TutorialsSection",
 CellID->354661674],
Cell[5026, 163, 187, 4, 70, "Tutorials",
 CellID->208744827]
}, Open  ]],
Cell[CellGroupData[{
Cell[5250, 172, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5572, 183, 160, 3, 70, "MoreAbout",
 CellID->65639680]
}, Open  ]],
Cell[5747, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

