(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7763,        254]
NotebookOptionsPosition[      6013,        199]
NotebookOutlinePosition[      7077,        228]
CellTagsIndexPosition[      7034,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LexicographicSubsets" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/LexicographicSubsets"], "NextKSubset" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/NextKSubset"], 
          "RandomKSubset" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RandomKSubset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LexicographicSubsets\"\>", 
       2->"\<\"NextKSubset\"\>", 
       3->"\<\"RandomKSubset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsets and Cycles" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndCycles"], 
          "Subsets and Permutations" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/SubsetsAndPermutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subsets and Cycles\"\>", 
       2->"\<\"Subsets and Permutations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KSubsets", "ObjectName",
 CellID->19409],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KSubsets", "[", 
       RowBox[{
        StyleBox["l", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives all subsets of set ",
     Cell[BoxData[
      FormBox["l", TraditionalForm]], "InlineMath"],
     " containing exactly ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " elements, ordered lexicographically."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17764]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2151],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LexicographicSubsets",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/LexicographicSubsets"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NextKSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NextKSubset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomKSubset",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomKSubset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26382652],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->2062061]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Subsets and Cycles",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/SubsetsAndCycles"]], "MoreAbout",
 CellID->219504612],

Cell[TextData[ButtonBox["Subsets and Permutations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Combinatorica/guide/SubsetsAndPermutations"]], "MoreAbout",
 CellID->660642294]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KSubsets - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 50, 59.1666172}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "KSubsets[l, k] gives all subsets of set l containing exactly k elements, \
ordered lexicographically.", "synonyms" -> {}, "title" -> "KSubsets", "type" -> 
    "Symbol", "uri" -> "Combinatorica/ref/KSubsets"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2281, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2904, 84, 46, 1, 70, "ObjectName",
 CellID->19409],
Cell[2953, 87, 651, 20, 70, "Usage",
 CellID->17764]
}, Open  ]],
Cell[CellGroupData[{
Cell[3641, 112, 310, 9, 70, "SeeAlsoSection",
 CellID->2151],
Cell[3954, 123, 778, 26, 70, "SeeAlso",
 CellID->15184]
}, Open  ]],
Cell[CellGroupData[{
Cell[4769, 154, 317, 9, 70, "TutorialsSection",
 CellID->26382652],
Cell[5089, 165, 185, 4, 70, "Tutorials",
 CellID->2062061]
}, Open  ]],
Cell[CellGroupData[{
Cell[5311, 174, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5633, 185, 160, 3, 70, "MoreAbout",
 CellID->219504612],
Cell[5796, 190, 175, 4, 70, "MoreAbout",
 CellID->660642294]
}, Open  ]],
Cell[5986, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

