(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8498,        275]
NotebookOptionsPosition[      6544,        218]
NotebookOutlinePosition[      7870,        251]
CellTagsIndexPosition[      7827,        248]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberOfGraphs" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/NumberOfGraphs"],
           "RandomGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/RandomGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NumberOfGraphs\"\>", 
       2->"\<\"RandomGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListGraphs", "ObjectName",
 CellID->22811],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListGraphs", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns all nonisomorphic undirected graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " edges. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListGraphs", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        ButtonBox["Directed",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns all nonisomorphic directed graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " edges. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListGraphs", "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns all nonisomorphic undirected graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ListGraphs", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        ButtonBox["Directed",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Directed"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns all nonisomorphic directed graphs with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vertices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28215]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22856],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfGraphs",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfGraphs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/RandomGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5187]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->349305498],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->173390657]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->100423867]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListGraphs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 6.7605616}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "ListGraphs[n, m] returns all nonisomorphic undirected graphs with n \
vertices and m edges. ListGraphs[n, m, Directed] returns all nonisomorphic \
directed graphs with n vertices and m edges. ListGraphs[n] returns all \
nonisomorphic undirected graphs with n vertices. ListGraphs[n, Directed] \
returns all nonisomorphic directed graphs with n vertices.", "synonyms" -> {},
     "title" -> "ListGraphs", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/ListGraphs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1922, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2545, 77, 48, 1, 70, "ObjectName",
 CellID->22811],
Cell[2596, 80, 1998, 61, 70, "Usage",
 CellID->28215]
}, Open  ]],
Cell[CellGroupData[{
Cell[4631, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->22856],
Cell[4945, 157, 496, 17, 70, "SeeAlso",
 CellID->5187]
}, Open  ]],
Cell[CellGroupData[{
Cell[5478, 179, 318, 9, 70, "TutorialsSection",
 CellID->349305498],
Cell[5799, 190, 187, 4, 70, "Tutorials",
 CellID->173390657]
}, Open  ]],
Cell[CellGroupData[{
Cell[6023, 199, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6345, 210, 157, 3, 70, "MoreAbout",
 CellID->100423867]
}, Open  ]],
Cell[6517, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

