(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8440,        285]
NotebookOptionsPosition[      6416,        222]
NotebookOutlinePosition[      7565,        252]
CellTagsIndexPosition[      7522,        249]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MakeUndirected" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/MakeUndirected"],
           "OrientGraph" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/OrientGraph"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MakeUndirected\"\>", 
       2->"\<\"OrientGraph\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Graphs" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/ConstructingGraphs"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Constructing Graphs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MakeDirected", "ObjectName",
 CellID->21925],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MakeDirected", "[", 
       StyleBox["g", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs a directed graph from a given undirected \
graph ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " by replacing each undirected edge in ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " by two directed edges pointing in opposite directions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26458]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The local options associated with edges are not inherited by the \
corresponding directed edges. \
\>", "Notes",
 CellID->26461],

Cell[TextData[{
 "Calling the function with the tag ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", as ",
 Cell[BoxData[
  RowBox[{"MakeDirected", "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 ", ensures that local options associated with each edge are inherited by \
both corresponding directed edges."
}], "Notes",
 CellID->367109406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5044],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeUndirected",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/MakeUndirected"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrientGraph",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/OrientGraph"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->121238849],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->327528492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Constructing Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/ConstructingGraphs"]], "MoreAbout",
 CellID->80629137]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MakeDirected - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 14.4326330}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "MakeDirected[g] constructs a directed graph from a given undirected \
graph g by replacing each undirected edge in g by two directed edges pointing \
in opposite directions. ", "synonyms" -> {}, "title" -> "MakeDirected", 
    "type" -> "Symbol", "uri" -> "Combinatorica/ref/MakeDirected"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1939, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2562, 78, 50, 1, 70, "ObjectName",
 CellID->21925],
Cell[2615, 81, 673, 19, 70, "Usage",
 CellID->26458]
}, Open  ]],
Cell[CellGroupData[{
Cell[3325, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3803, 122, 138, 4, 70, "Notes",
 CellID->26461],
Cell[3944, 128, 517, 17, 70, "Notes",
 CellID->367109406]
}, Closed]],
Cell[CellGroupData[{
Cell[4498, 150, 310, 9, 70, "SeeAlsoSection",
 CellID->5044],
Cell[4811, 161, 497, 17, 70, "SeeAlso",
 CellID->18251]
}, Open  ]],
Cell[CellGroupData[{
Cell[5345, 183, 318, 9, 70, "TutorialsSection",
 CellID->121238849],
Cell[5666, 194, 187, 4, 70, "Tutorials",
 CellID->327528492]
}, Open  ]],
Cell[CellGroupData[{
Cell[5890, 203, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[6212, 214, 162, 3, 70, "MoreAbout",
 CellID->80629137]
}, Open  ]],
Cell[6389, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

