(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8167,        257]
NotebookOptionsPosition[      6097,        199]
NotebookOutlinePosition[      7541,        233]
CellTagsIndexPosition[      7498,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListNecklaces" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/ListNecklaces"], 
          "NumberOfNecklaces" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/ref/NumberOfNecklaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListNecklaces\"\>", 
       2->"\<\"NumberOfNecklaces\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Properties" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphProperties"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NecklacePolynomial", "ObjectName",
 CellID->6699],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NecklacePolynomial", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        ButtonBox["Cyclic",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Cyclic"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]returns a polynomial in the colors in ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " whose coefficients represent numbers of ways of coloring an ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     "-bead necklace with colors chosen from ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     ", assuming that two colorings are equivalent if one can be obtained \
from the other by a rotation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NecklacePolynomial", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        ButtonBox["Dihedral",
         BaseStyle->"Link",
         ButtonData->"paclet:Combinatorica/ref/Dihedral"]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]is different in that it considers two colorings \
equivalent if one can be obtained from the other by a rotation or a flip or \
both."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5756],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/ListNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberOfNecklaces",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/NumberOfNecklaces"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250415405],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->190120701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphProperties"]], "MoreAbout",
 CellID->36776276]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NecklacePolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 30.7455506}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NecklacePolynomial[n, c, Cyclic] returns a polynomial in the colors in c \
whose coefficients represent numbers of ways of coloring an n-bead necklace \
with colors chosen from c, assuming that two colorings are equivalent if one \
can be obtained from the other by a rotation. NecklacePolynomial[n, c, \
Dihedral] is different in that it considers two colorings equivalent if one \
can be obtained from the other by a rotation or a flip or both.", 
    "synonyms" -> {}, "title" -> "NecklacePolynomial", "type" -> "Symbol", 
    "uri" -> "Combinatorica/ref/NecklacePolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1937, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2560, 77, 55, 1, 70, "ObjectName",
 CellID->6699],
Cell[2618, 80, 1520, 42, 70, "Usage",
 CellID->16334]
}, Open  ]],
Cell[CellGroupData[{
Cell[4175, 127, 310, 9, 70, "SeeAlsoSection",
 CellID->5756],
Cell[4488, 138, 507, 17, 70, "SeeAlso",
 CellID->26654]
}, Open  ]],
Cell[CellGroupData[{
Cell[5032, 160, 318, 9, 70, "TutorialsSection",
 CellID->250415405],
Cell[5353, 171, 187, 4, 70, "Tutorials",
 CellID->190120701]
}, Open  ]],
Cell[CellGroupData[{
Cell[5577, 180, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5899, 191, 156, 3, 70, "MoreAbout",
 CellID->36776276]
}, Open  ]],
Cell[6070, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

