(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7556,        249]
NotebookOptionsPosition[      5716,        194]
NotebookOutlinePosition[      6930,        225]
CellTagsIndexPosition[      6887,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMBINATORICA PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorica" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/tutorial/Combinatorica"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Combinatorica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphPower" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/GraphPower"], 
          "Invariants" :> 
          Documentation`HelpLookup["paclet:Combinatorica/ref/Invariants"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GraphPower\"\>", 
       2->"\<\"Invariants\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graph Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:Combinatorica/guide/GraphAlgorithms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graph Algorithms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NumberOfKPaths", "ObjectName",
 CellID->27781],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfKPaths", "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a sorted list that contains the number of paths \
of length ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " to different vertices of ",
     Cell[BoxData[
      FormBox["g", TraditionalForm]], "InlineMath"],
     " from ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NumberOfKPaths", "[", 
       RowBox[{
        StyleBox["al", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]behaves identically, except that it takes an adjacency \
list ",
     Cell[BoxData[
      StyleBox["al", "TI"]], "InlineFormula"],
     " as input."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1285],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPower",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/GraphPower"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Invariants",
    BaseStyle->"Link",
    ButtonData->"paclet:Combinatorica/ref/Invariants"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->740877938],

Cell[TextData[StyleBox[ButtonBox["Combinatorica",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/tutorial/Combinatorica"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->370873068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Graph Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:Combinatorica/guide/GraphAlgorithms"]], "MoreAbout",
 CellID->460832656]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NumberOfKPaths - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 51, 54.8242920}", "context" -> 
    "Combinatorica`", "keywords" -> {}, "index" -> True, "label" -> 
    "Combinatorica Package Symbol", "language" -> "en", "paclet" -> 
    "Combinatorica Package", "status" -> "None", "summary" -> 
    "NumberOfKPaths[g, v, k] returns a sorted list that contains the number \
of paths of length k to different vertices of g from v. NumberOfKPaths[al, v, \
k] behaves identically, except that it takes an adjacency list al as input.", 
    "synonyms" -> {}, "title" -> "NumberOfKPaths", "type" -> "Symbol", "uri" -> 
    "Combinatorica/ref/NumberOfKPaths"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1896, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2519, 76, 52, 1, 70, "ObjectName",
 CellID->27781],
Cell[2574, 79, 1203, 38, 70, "Usage",
 CellID->3765]
}, Open  ]],
Cell[CellGroupData[{
Cell[3814, 122, 310, 9, 70, "SeeAlsoSection",
 CellID->1285],
Cell[4127, 133, 486, 17, 70, "SeeAlso",
 CellID->2433]
}, Open  ]],
Cell[CellGroupData[{
Cell[4650, 155, 318, 9, 70, "TutorialsSection",
 CellID->740877938],
Cell[4971, 166, 187, 4, 70, "Tutorials",
 CellID->370873068]
}, Open  ]],
Cell[CellGroupData[{
Cell[5195, 175, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[5517, 186, 157, 3, 70, "MoreAbout",
 CellID->460832656]
}, Open  ]],
Cell[5689, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

